/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationDescriptor;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationRegistry;

public class NotificationRegistryImpl
extends MapRegistry
implements NotificationRegistry {
    protected final Map<String, List<Notification>> notificationsByEvent = new ConcurrentHashMap<String, List<Notification>>();

    public void initialize() {
        super.initialize();
        this.notificationsByEvent.clear();
        this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).map(Map.Entry::getValue).map(NotificationDescriptor.class::cast).forEach(n -> n.getEvents().forEach(event -> this.notificationsByEvent.computeIfAbsent((String)event, k -> new ArrayList()).add(n)));
    }

    @Override
    public Set<String> getNotificationEventNames() {
        return this.notificationsByEvent.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public List<Notification> getNotificationsForEvent(String eventId) {
        if (eventId == null) {
            return Collections.emptyList();
        }
        this.checkInitialized();
        return this.notificationsByEvent.computeIfAbsent(eventId, k -> new ArrayList());
    }

    @Override
    public List<Notification> getNotifications() {
        return this.getContributionValues();
    }

    @Override
    public List<Notification> getNotificationsForSubscriptions(String parentType) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification notification : this.getNotifications()) {
            if (notification.getAutoSubscribed()) continue;
            String type = notification.getAvailableIn();
            if (type == null || "all".equals(type) || "*".equals(type)) {
                result.add(notification);
                continue;
            }
            String[] types = type.replace(",", " ").split(" ");
            if (!Arrays.asList(types).contains(parentType)) continue;
            result.add(notification);
        }
        return result;
    }
}

