/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.service;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerHook;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerVeto;
import org.nuxeo.ecm.platform.ec.notification.SubscriptionAdapter;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.service.GeneralSettingsDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationListenerHookDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationListenerVetoDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.notification.api.NotificationRegistry;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class NotificationService
extends DefaultComponent
implements NotificationManager {
    private static final Log log = LogFactory.getLog(NotificationService.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.ec.notification.service.NotificationService");
    protected static final String NOTIFICATIONS_EP = "notifications";
    protected static final String TEMPLATES_EP = "templates";
    protected static final String GENERAL_SETTINGS_EP = "generalSettings";
    protected static final GeneralSettingsDescriptor DEFAULT_SETTINGS = new GeneralSettingsDescriptor("http://localhost:8080/nuxeo/", "[Nuxeo]", "java:/Mail");
    protected static final String NOTIFICATION_HOOK_EP = "notificationListenerHook";
    protected static final String NOTIFICATION_VETO_EP = "notificationListenerVeto";
    protected EmailHelper emailHelper = new EmailHelper();
    protected Map<String, NotificationListenerHook> hookListeners;
    protected List<NotificationListenerVeto> vetos;
    protected EventProducer producer;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(NotificationManager.class)) {
            return (T)this;
        }
        return null;
    }

    public void start(ComponentContext context) {
        this.hookListeners = new HashMap<String, NotificationListenerHook>();
        List hooks = this.getRegistryContributions(NOTIFICATION_HOOK_EP);
        for (NotificationListenerHookDescriptor desc : hooks) {
            try {
                this.hookListeners.put(desc.name, desc.hookListener.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        this.vetos = new ArrayList<NotificationListenerVeto>();
        List vetoDescs = this.getRegistryContributions(NOTIFICATION_VETO_EP);
        for (NotificationListenerVetoDescriptor desc : vetoDescs) {
            try {
                this.vetos.add(desc.getNotificationVeto().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.hookListeners = null;
        this.vetos = null;
    }

    @Override
    public List<String> getSubscribers(String notification, DocumentModel doc) {
        return ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).getNotificationSubscribers(notification);
    }

    @Override
    public List<String> getSubscriptionsForUserOnDocument(String username, DocumentModel doc) {
        return ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).getUserSubscriptions(username);
    }

    protected void disableEvents(DocumentModel doc) {
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
    }

    protected void restoreEvents(DocumentModel doc) {
        doc.putContextData("disableDublinCoreListener", null);
        doc.putContextData("disableNotificationService", null);
        doc.putContextData("disableAuditLogger", null);
        doc.putContextData("DisableAutoCheckOut", null);
    }

    @Override
    public void addSubscription(String username, String notification, DocumentModel doc, Boolean sendConfirmationEmail, NuxeoPrincipal principal, String notificationName) {
        CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> {
            ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).addSubscription(username, notification);
            this.disableEvents(doc);
            session.saveDocument(doc);
            this.restoreEvents(doc);
        });
        if (Boolean.TRUE.equals(sendConfirmationEmail)) {
            this.raiseConfirmationEvent(principal, doc, username, notificationName);
        }
    }

    @Override
    public void addSubscriptions(String username, DocumentModel doc, Boolean sendConfirmationEmail, NuxeoPrincipal principal) {
        CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> {
            ((SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class)).addSubscriptionsToAll(username);
            this.disableEvents(doc);
            session.saveDocument(doc);
            this.restoreEvents(doc);
        });
        if (Boolean.TRUE.equals(sendConfirmationEmail)) {
            this.raiseConfirmationEvent(principal, doc, username, "All Notifications");
        }
    }

    @Override
    public void removeSubscriptions(String username, List<String> notifications, DocumentModel doc) {
        CoreInstance.doPrivileged((String)doc.getRepositoryName(), session -> {
            SubscriptionAdapter sa = (SubscriptionAdapter)doc.getAdapter(SubscriptionAdapter.class);
            for (String notification : notifications) {
                sa.removeUserNotificationSubscription(username, notification);
            }
            this.disableEvents(doc);
            session.saveDocument(doc);
            this.restoreEvents(doc);
        });
    }

    protected void doFireEvent(Event event) {
        if (this.producer == null) {
            this.producer = (EventProducer)Framework.getService(EventProducer.class);
        }
        this.producer.fireEvent(event);
    }

    private void raiseConfirmationEvent(NuxeoPrincipal principal, DocumentModel doc, String username, String notification) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("repositoryName", doc.getRepositoryName());
        options.put("recipients", username);
        options.put("notifName", notification);
        CoreSession session = doc.getCoreSession();
        DocumentEventContext ctx = new DocumentEventContext(session, principal, doc);
        ctx.setCategory("clientCodeNotificationCategory");
        ctx.setProperties(options);
        Event event = ctx.newEvent("subscriptionAssigned");
        this.doFireEvent(event);
    }

    @Override
    public void removeSubscription(String username, String notification, DocumentModel doc) {
        this.removeSubscriptions(username, Collections.singletonList(notification), doc);
    }

    public URL getTemplateURL(String name) {
        return this.getRegistryContribution(TEMPLATES_EP, name).map(t -> t.getSrc().toURL()).orElse(null);
    }

    protected GeneralSettingsDescriptor getGeneralSettings() {
        return this.getRegistryContribution(GENERAL_SETTINGS_EP).orElse(DEFAULT_SETTINGS);
    }

    public String getServerUrlPrefix() {
        return this.getGeneralSettings().getServerPrefix();
    }

    public String getEMailSubjectPrefix() {
        return this.getGeneralSettings().getEMailSubjectPrefix();
    }

    public String getMailSessionJndiName() {
        return this.getGeneralSettings().getMailSessionJndiName();
    }

    @Override
    public Notification getNotificationByName(String selectedNotification) {
        return this.getRegistryContribution(NOTIFICATIONS_EP, selectedNotification).orElse(null);
    }

    @Override
    public void sendNotification(String notificationName, Map<String, Object> infoMap, String userPrincipal) {
        Object subject;
        Notification notif = this.getNotificationByName(notificationName);
        NuxeoPrincipal recipient = NotificationServiceHelper.getUsersService().getPrincipal(userPrincipal);
        String email = recipient.getEmail();
        String mailTemplate = notif.getTemplate();
        infoMap.put("mail.to", email);
        String authorUsername = (String)infoMap.get("author");
        if (authorUsername != null) {
            NuxeoPrincipal author = NotificationServiceHelper.getUsersService().getPrincipal(authorUsername);
            infoMap.put("principalAuthor", author);
        }
        Object object = subject = notif.getSubject() == null ? "Alert" : notif.getSubject();
        if (notif.getSubjectTemplate() != null) {
            subject = notif.getSubjectTemplate();
        }
        subject = NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + " " + (String)subject;
        infoMap.put("subject", subject);
        infoMap.put("template", mailTemplate);
        try {
            this.emailHelper.sendmail(infoMap);
        }
        catch (MessagingException e) {
            throw new NuxeoException("Failed to send notification email ", (Throwable)e);
        }
    }

    @Override
    public void sendDocumentByMail(DocumentModel doc, String freemarkerTemplateName, String subject, String comment, NuxeoPrincipal sender, List<String> sendTo) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("document", doc);
        infoMap.put("subject", subject);
        infoMap.put("comment", comment);
        infoMap.put("sender", sender);
        DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc);
        docView.setViewId("view_documents");
        infoMap.put("docUrl", this.getDocLocator().getUrlFromDocumentView((DocumentView)docView, true, NotificationServiceHelper.getNotificationService().getServerUrlPrefix()));
        if (freemarkerTemplateName == null) {
            freemarkerTemplateName = "defaultNotifTemplate";
        }
        infoMap.put("template", freemarkerTemplateName);
        for (String to : sendTo) {
            infoMap.put("mail.to", to);
            try {
                this.emailHelper.sendmail(infoMap);
            }
            catch (MessagingException e) {
                log.debug((Object)("Failed to send notification email " + e));
            }
        }
    }

    private DocumentViewCodecManager getDocLocator() {
        return (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
    }

    @Override
    public List<Notification> getNotificationsForSubscriptions(String parentType) {
        return ((NotificationRegistry)this.getExtensionPointRegistry(NOTIFICATIONS_EP)).getNotificationsForSubscriptions(parentType);
    }

    @Override
    public List<Notification> getNotificationsForEvents(String eventId) {
        return ((NotificationRegistry)this.getExtensionPointRegistry(NOTIFICATIONS_EP)).getNotificationsForEvent(eventId);
    }

    public EmailHelper getEmailHelper() {
        return this.emailHelper;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }

    @Override
    public Set<String> getNotificationEventNames() {
        return ((NotificationRegistry)this.getExtensionPointRegistry(NOTIFICATIONS_EP)).getNotificationEventNames();
    }

    public Collection<NotificationListenerHook> getListenerHooks() {
        return this.hookListeners.values();
    }

    public Collection<NotificationListenerVeto> getNotificationVetos() {
        return Collections.unmodifiableCollection(this.vetos);
    }

    @Override
    public List<String> getUsersSubscribedToNotificationOnDocument(String notification, DocumentModel doc) {
        return this.getSubscribers(notification, doc);
    }

    @Override
    public List<DocumentModel> getSubscribedDocuments(String prefixedPrincipalName, String repositoryName) {
        String nxql = "SELECT * FROM Document WHERE ecm:mixinType = 'Notifiable' AND ecm:isVersion = 0 AND notif:notifications/*/subscribers/* = " + NXQL.escapeString((String)prefixedPrincipalName);
        return (List)CoreInstance.doPrivileged((String)repositoryName, s -> s.query(nxql).stream().map(NotificationService::detachDocumentModel).collect(Collectors.toList()));
    }

    protected static DocumentModel detachDocumentModel(DocumentModel doc) {
        doc.detach(true);
        return doc;
    }
}

