/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUnicityChecker {
    private static final Logger log = LogManager.getLogger(AbstractUnicityChecker.class);
    protected static final String DUPLICATED_FILE = "duplicatedFile";

    protected void doUnicityCheck(DocumentModel doc2Check, CoreSession session, Event event) {
        List<String> xpathFields = ((FileManager)Framework.getService(FileManager.class)).getFields();
        if (xpathFields == null || xpathFields.isEmpty()) {
            log.info("Unicity check has been automatically disabled");
            return;
        }
        for (String field : xpathFields) {
            Blob blob;
            try {
                blob = (Blob)doc2Check.getPropertyValue(field);
            }
            catch (PropertyNotFoundException pnfe) {
                continue;
            }
            if (blob == null) {
                log.debug("No blob retrieved");
                continue;
            }
            String digest = blob.getDigest();
            if (digest == null) {
                log.debug("Blob has no digest, can not check for unicity");
                continue;
            }
            List<DocumentLocation> existingDocuments = ((FileManager)Framework.getService(FileManager.class)).findExistingDocumentWithFile(session, doc2Check.getPathAsString(), digest, session.getPrincipal());
            if (existingDocuments.isEmpty()) continue;
            existingDocuments.removeIf(documentLocation -> documentLocation.getDocRef() == doc2Check.getRef());
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = existingDocuments::size;
            log.debug("Existing Documents[{}]", supplierArray);
            this.onDuplicatedDoc(session, session.getPrincipal(), doc2Check, existingDocuments, event);
        }
    }

    protected abstract void onDuplicatedDoc(CoreSession var1, NuxeoPrincipal var2, DocumentModel var3, List<DocumentLocation> var4, Event var5);

    protected void raiseDuplicatedFileEvent(CoreSession session, NuxeoPrincipal principal, DocumentModel newDoc, List<DocumentLocation> existingDocs) {
        DocumentEventContext ctx = new DocumentEventContext(session, principal, newDoc);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("category", "clientCodeNotificationCategory");
        props.put("duplicatedDocLocation", (Serializable)((Object)existingDocs));
        ctx.setProperties(props);
        Event event = ctx.newEvent(DUPLICATED_FILE);
        EventProducer producer = (EventProducer)Framework.getService(EventProducer.class);
        producer.fireEvent(event);
    }

    protected boolean isUnicityCheckEnabled() {
        return ((FileManager)Framework.getService(FileManager.class)).isUnicityEnabled();
    }
}

