/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;
import org.nuxeo.runtime.api.Framework;

public class DefaultFileImporter
extends AbstractFileImporter {
    public static final String TYPE_NAME = "File";
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isOverwriteByTitle() {
        return false;
    }

    @Override
    public String getDocType(DocumentModel container) {
        String type = super.getDocType(container);
        if (type == null) {
            type = DefaultFileImporter.getTypeName(container);
        }
        return type;
    }

    public static String getTypeName(DocumentModel currentDoc) {
        String defaultType;
        UITypesConfiguration configuration = DefaultFileImporter.getConfiguration(currentDoc);
        if (configuration != null && StringUtils.isNotBlank((CharSequence)(defaultType = configuration.getDefaultType()))) {
            return defaultType;
        }
        return TYPE_NAME;
    }

    protected static UITypesConfiguration getConfiguration(DocumentModel currentDoc) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        return (UITypesConfiguration)localConfigurationService.getConfiguration(UITypesConfiguration.class, "UITypesLocalConfiguration", currentDoc);
    }
}

