/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;
import org.nuxeo.ecm.core.persistence.NuxeoConnectionProvider;
import org.nuxeo.ecm.core.persistence.PersistenceError;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.jtajca.NamingContextFactory;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

@XObject(value="hibernateConfiguration")
@XRegistry
public class HibernateConfiguration
implements EntityManagerFactoryProvider {
    public static final String RESOURCE_LOCAL = PersistenceUnitTransactionType.RESOURCE_LOCAL.name();
    public static final String JTA = PersistenceUnitTransactionType.JTA.name();
    public static final String TXTYPE_PROPERTY_NAME = "org.nuxeo.runtime.txType";
    @XNode(value="@name")
    @XRegistryId
    public String name;
    @XNodeMap(value="properties/property", key="@name", type=Properties.class, componentType=String.class)
    public final Properties hibernateProperties = new Properties();
    @XNodeList(value="classes/class", type=ArrayList.class, componentType=Class.class)
    public final List<Class<?>> annotedClasses = new ArrayList();

    @XNode(value="datasource")
    public void setDatasource(String name) {
        String expandedValue = Framework.expandVars((String)name);
        if (expandedValue.startsWith("$")) {
            throw new PersistenceError("Cannot expand " + name + " for datasource");
        }
        this.hibernateProperties.put("hibernate.connection.datasource", DataSourceHelper.getDataSourceJNDIName((String)name));
    }

    public void addAnnotedClass(Class<?> annotedClass) {
        this.annotedClasses.add(annotedClass);
    }

    public void removeAnnotedClass(Class<?> annotedClass) {
        this.annotedClasses.remove(annotedClass);
    }

    @Override
    public EntityManagerFactory getFactory(String txType) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.putAll(this.hibernateProperties);
        properties.put("hibernate.ejb.loaded.classes", this.annotedClasses);
        if (txType == null) {
            txType = HibernateConfiguration.getTxType();
        }
        properties.put("javax.persistence.transactionType", txType);
        if (txType.equals(JTA)) {
            properties.put("hibernate.transaction.jta.platform", (Object)new NuxeoJtaPlatform());
            String dsname = (String)properties.get("hibernate.connection.datasource");
            dsname = DataSourceHelper.getDataSourceJNDIName((String)dsname);
            properties.put("hibernate.connection.datasource", dsname);
            properties.put("hibernate.jndi.class", NamingContextFactory.class.getName());
            properties.put("hibernate.jndi.java.naming.factory.url.pkgs", NuxeoContainer.class.getPackage().getName());
        } else {
            properties.remove("hibernate.connection.datasource");
        }
        if (properties.get("hibernate.connection.url") == null) {
            properties.put("hibernate.connection.provider_class", new NuxeoConnectionProvider());
        }
        return new HibernatePersistenceProvider().createEntityManagerFactory(this.name, properties);
    }

    @Override
    public EntityManagerFactory getFactory() {
        return this.getFactory(null);
    }

    public static String getTxType() {
        String txType;
        if (Framework.isInitialized()) {
            txType = Framework.getProperty((String)TXTYPE_PROPERTY_NAME);
            if (txType == null) {
                try {
                    TransactionHelper.lookupTransactionManager();
                    txType = JTA;
                }
                catch (NamingException e) {
                    txType = RESOURCE_LOCAL;
                }
            }
        } else {
            txType = RESOURCE_LOCAL;
        }
        return txType;
    }

    public static HibernateConfiguration load(URL location) {
        XMap map = new XMap();
        map.register(HibernateConfiguration.class);
        try {
            return (HibernateConfiguration)map.load(location);
        }
        catch (IOException e) {
            throw new PersistenceError("Cannot load hibernate configuration from " + location, e);
        }
    }

    public static class NuxeoJtaPlatform
    extends AbstractJtaPlatform {
        private static final long serialVersionUID = 1L;

        protected TransactionManager locateTransactionManager() {
            try {
                return TransactionHelper.lookupTransactionManager();
            }
            catch (NamingException e) {
                throw new JtaPlatformException(e.getMessage(), (Throwable)e);
            }
        }

        protected UserTransaction locateUserTransaction() {
            try {
                return TransactionHelper.lookupUserTransaction();
            }
            catch (NamingException e) {
                throw new JtaPlatformException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

