/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.service;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeDescriptor;
import org.w3c.dom.Element;

public class MimetypeDescriptorRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(MimetypeDescriptorRegistry.class);
    protected Map<String, MimetypeEntry> mimetypeByNormalizedRegistry = new ConcurrentHashMap<String, MimetypeEntry>();
    protected Map<String, MimetypeEntry> mimetypeByExtensionRegistry = new ConcurrentHashMap<String, MimetypeEntry>();

    public void initialize() {
        this.mimetypeByNormalizedRegistry.clear();
        this.mimetypeByExtensionRegistry.clear();
        super.initialize();
    }

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        MimetypeDescriptor desc = (MimetypeDescriptor)super.doRegister(ctx, xObject, element, extensionId);
        if (desc != null) {
            MimetypeEntry mimetype = desc.getMimetype();
            log.debug("Registering mimetype: {}", (Object)mimetype.getNormalized());
            this.mimetypeByNormalizedRegistry.put(mimetype.getNormalized(), mimetype);
            for (String extension : mimetype.getExtensions()) {
                this.mimetypeByExtensionRegistry.put(extension, mimetype);
            }
        }
        return (T)desc;
    }

    public boolean isNormalized(String mimeType) {
        return mimeType != null && this.mimetypeByNormalizedRegistry.containsKey(mimeType);
    }

    public MimetypeEntry getEntryByName(String name) {
        if (name == null) {
            return null;
        }
        return this.mimetypeByNormalizedRegistry.get(name);
    }

    public MimetypeEntry getEntryByExtension(String extension) {
        if (extension == null) {
            return null;
        }
        return this.mimetypeByExtensionRegistry.get(extension);
    }

    public Set<Map.Entry<String, MimetypeEntry>> getEntryKeys() {
        return this.mimetypeByNormalizedRegistry.entrySet();
    }
}

