/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ManagementRuntimeException;
import org.nuxeo.runtime.management.ObjectNameFactory;
import org.nuxeo.runtime.management.Resource;
import org.nuxeo.runtime.management.ResourceFactory;
import org.nuxeo.runtime.management.ResourceFactoryDescriptor;
import org.nuxeo.runtime.management.ResourcePublisher;
import org.nuxeo.runtime.management.ResourcePublisherMBean;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.management.ServerLocatorService;
import org.nuxeo.runtime.management.ServiceDescriptor;
import org.nuxeo.runtime.management.ShortcutDescriptor;
import org.nuxeo.runtime.management.inspector.ModelMBeanInfoFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class ResourcePublisherService
extends DefaultComponent
implements ResourcePublisher,
ResourcePublisherMBean {
    private static final Logger log = LogManager.getLogger(ResourcePublisherService.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.management.ResourcePublisher");
    public static final String SERVICES_EXT_KEY = "services";
    public static final String FACTORIES_EXT_KEY = "factories";
    public static final String SHORTCUTS_EXT_KEY = "shortcuts";
    protected ShortcutsRegistry shortcutsRegistry;
    protected FactoriesRegistry factoriesRegistry;
    protected ResourcesRegistry resourcesRegistry;
    protected ServerLocatorService serverLocatorService;
    protected boolean started = false;

    public void activate(ComponentContext context) {
        this.serverLocatorService = (ServerLocatorService)Framework.getService(ServerLocator.class);
    }

    public void deactivate(ComponentContext context) {
        this.serverLocatorService = null;
    }

    public int getApplicationStartedOrder() {
        return this.serverLocatorService.getApplicationStartedOrder() + 1;
    }

    public void start(ComponentContext context) {
        this.shortcutsRegistry = new ShortcutsRegistry();
        this.factoriesRegistry = new FactoriesRegistry();
        this.resourcesRegistry = new ResourcesRegistry();
        this.getRegistryContributions(SERVICES_EXT_KEY).forEach(this.resourcesRegistry::doRegisterResource);
        this.getRegistryContributions(FACTORIES_EXT_KEY).forEach(this.factoriesRegistry::doRegisterFactory);
        this.getRegistryContributions(SHORTCUTS_EXT_KEY).forEach(this.shortcutsRegistry::doRegisterShortcut);
        this.started = true;
        this.factoriesRegistry.doRegisterResources();
        this.doBindResources();
    }

    public void stop(ComponentContext context) {
        this.started = false;
        this.doUnbindResources();
        this.shortcutsRegistry = null;
        this.factoriesRegistry = null;
        this.resourcesRegistry = null;
    }

    @Override
    public void registerResource(String shortName, String qualifiedName, Class<?> managementClass, Object instance) {
        this.resourcesRegistry.doRegisterResource(qualifiedName, managementClass, instance);
        if (shortName != null) {
            this.shortcutsRegistry.doRegisterShortcut(shortName, qualifiedName);
        }
    }

    @Override
    public void unregisterResource(String shortName, String qualifiedName) {
        this.resourcesRegistry.doUnregisterResource(qualifiedName);
        if (shortName != null) {
            this.shortcutsRegistry.unregisterShortcut(shortName);
        }
    }

    @Override
    public Set<String> getShortcutsName() {
        return new HashSet<String>(this.shortcutsRegistry.registry.keySet());
    }

    @Override
    public Set<ObjectName> getResourcesName() {
        return new HashSet<ObjectName>(this.resourcesRegistry.registry.keySet());
    }

    @Override
    public ObjectName lookupName(String name) {
        if (!this.shortcutsRegistry.registry.containsKey(name)) {
            return ObjectNameFactory.getObjectName(name);
        }
        return this.shortcutsRegistry.registry.get(name);
    }

    protected void doBindResources() {
        for (Resource resource : this.resourcesRegistry.registry.values()) {
            if (resource.mbean != null) continue;
            this.resourcesRegistry.doBind(resource);
        }
    }

    @Override
    public void bindResources() {
        this.doBindResources();
    }

    protected void doUnbindResources() {
        for (Resource resource : this.resourcesRegistry.registry.values()) {
            if (resource.mbean == null) continue;
            this.resourcesRegistry.doUnbind(resource);
        }
    }

    @Override
    public void unbindResources() {
        this.doUnbindResources();
    }

    public void bindResource(ObjectName name) {
        Resource resource = this.resourcesRegistry.registry.get(name);
        if (resource == null) {
            throw new IllegalArgumentException(name + " is not registered");
        }
        this.resourcesRegistry.doBind(resource);
    }

    public void unbindResource(ObjectName name) {
        Resource resource = this.resourcesRegistry.registry.get(name);
        if (resource == null) {
            throw new IllegalArgumentException(name + " is not registered");
        }
        this.resourcesRegistry.doUnbind(resource);
    }

    protected void bindForTest(MBeanServer server, ObjectName name, Object instance, Class<?> clazz) throws JMException, InvalidTargetObjectTypeException {
        this.resourcesRegistry.doBind(server, name, instance, clazz);
    }

    protected class ResourcesRegistry {
        protected final Map<ObjectName, Resource> registry = new HashMap<ObjectName, Resource>();
        protected final ModelMBeanInfoFactory mbeanInfoFactory = new ModelMBeanInfoFactory();

        protected ResourcesRegistry() {
        }

        protected void doRegisterResource(String qualifiedName, Class<?> info, Object instance) {
            Resource resource = new Resource(ObjectNameFactory.getObjectName(qualifiedName), info, instance);
            this.doRegisterResource(resource);
        }

        protected void doRegisterResource(ServiceDescriptor descriptor) {
            Resource resource = this.doResolveServiceDescriptor(descriptor);
            this.doRegisterResource(resource);
            String shortName = descriptor.getName();
            if (StringUtils.isNotEmpty((CharSequence)shortName)) {
                ResourcePublisherService.this.shortcutsRegistry.doRegisterShortcut(shortName, resource.getManagementName());
            }
        }

        protected RequiredModelMBean doBind(MBeanServer server, ObjectName name, Object instance, Class<?> clazz) throws JMException, InvalidTargetObjectTypeException {
            RequiredModelMBean mbean = new RequiredModelMBean();
            mbean.setManagedResource(instance, "ObjectReference");
            mbean.setModelMBeanInfo(this.mbeanInfoFactory.getModelMBeanInfo(clazz));
            server.registerMBean(mbean, name);
            return mbean;
        }

        protected void doBind(Resource resource) {
            if (!ResourcePublisherService.this.started) {
                return;
            }
            if (resource.mbean != null) {
                throw new IllegalStateException(resource + " is already bound");
            }
            MBeanServer server = ResourcePublisherService.this.serverLocatorService.lookupServer(resource.managementName.getDomain());
            try {
                resource.mbean = this.doBind(server, resource.managementName, resource.instance, resource.clazz);
                if (log.isDebugEnabled()) {
                    log.debug("bound {}", (Object)resource);
                }
            }
            catch (JMException | InvalidTargetObjectTypeException e) {
                log.error("Cannot bind {}", (Object)resource, (Object)e);
            }
        }

        protected void doUnbind(Resource resource) {
            if (resource.mbean == null) {
                throw new IllegalStateException(resource.managementName + " is not bound");
            }
            try {
                MBeanServer server = ResourcePublisherService.this.serverLocatorService.lookupServer(resource.managementName);
                server.unregisterMBean(resource.managementName);
            }
            catch (JMException e) {
                throw ManagementRuntimeException.wrap("Cannot unbind " + resource, e);
            }
            finally {
                resource.mbean = null;
                if (log.isDebugEnabled()) {
                    log.debug("unbound {}", (Object)resource);
                }
            }
        }

        protected void doRegisterResource(Resource resource) {
            ObjectName name = resource.getManagementName();
            if (this.registry.containsKey(name)) {
                return;
            }
            this.registry.put(name, resource);
            this.doBind(resource);
            if (log.isDebugEnabled()) {
                log.debug("registered {}", (Object)name);
            }
        }

        protected ObjectName doResolveServiceName(ServiceDescriptor descriptor) {
            String qualifiedName = descriptor.getName();
            if (qualifiedName == null) {
                qualifiedName = ObjectNameFactory.getQualifiedName(descriptor.getResourceClass().getCanonicalName());
            }
            return ObjectNameFactory.getObjectName(qualifiedName);
        }

        protected Resource doResolveServiceDescriptor(ServiceDescriptor descriptor) {
            Class<?> resourceClass = descriptor.getResourceClass();
            Object resourceInstance = this.doResolveService(resourceClass);
            ObjectName managementName = this.doResolveServiceName(descriptor);
            Class<?> ifaceClass = descriptor.getIfaceClass();
            Class<?> managementClass = ifaceClass != null ? ifaceClass : resourceClass;
            return new Resource(managementName, managementClass, resourceInstance);
        }

        protected <T> T doResolveService(Class<T> resourceClass) {
            Object service = Framework.getService(resourceClass);
            if (service == null) {
                throw new ManagementRuntimeException("Cannot locate resource using " + resourceClass);
            }
            return (T)service;
        }

        protected void doUnregisterResource(String qualifiedName) {
            ObjectName objectName = ObjectNameFactory.getObjectName(qualifiedName);
            this.doUnregisterResource(objectName);
        }

        protected void doUnregisterResource(ObjectName objectName) {
            Resource resource = this.registry.remove(objectName);
            if (resource == null) {
                throw new IllegalArgumentException(objectName + " is not registered");
            }
            if (resource.mbean != null) {
                this.doUnbind(resource);
            }
        }
    }

    protected class ShortcutsRegistry {
        protected final Map<String, ObjectName> registry = new TreeMap<String, ObjectName>();

        protected ShortcutsRegistry() {
        }

        protected void doRegisterShortcut(ShortcutDescriptor descriptor) {
            this.doRegisterShortcut(descriptor.getShortName(), descriptor.getQualifiedName());
        }

        protected void doRegisterShortcut(String shortName, String qualifiedName) {
            this.registry.put(shortName, ObjectNameFactory.getObjectName(qualifiedName));
        }

        protected void doRegisterShortcut(String shortName, ObjectName qualifiedName) {
            this.registry.put(shortName, qualifiedName);
        }

        protected void unregisterShortcut(String name) {
            this.registry.remove(name);
        }
    }

    protected class FactoriesRegistry {
        protected final Map<Class<? extends ResourceFactory>, ResourceFactory> registry = new HashMap<Class<? extends ResourceFactory>, ResourceFactory>();

        protected FactoriesRegistry() {
        }

        protected void doRegisterFactory(ResourceFactoryDescriptor descriptor) {
            ResourceFactory factory;
            Class<? extends ResourceFactory> factoryClass = descriptor.getFactoryClass();
            try {
                factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new ManagementRuntimeException("Cannot create factory " + factoryClass, e);
            }
            factory.configure(ResourcePublisherService.this, descriptor);
            this.registry.put(factoryClass, factory);
        }

        protected void doRegisterResources() {
            this.registry.values().forEach(ResourceFactory::registerResources);
        }
    }
}

