/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.management.ManagementRuntimeException;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.management.ServerLocatorDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ServerLocatorService
extends DefaultComponent
implements ServerLocator {
    private static final Logger log = LogManager.getLogger(ServerLocatorService.class);
    public static final String LOCATORS_EXT_KEY = "locators";
    protected static final MBeanServer DEFAULT_SERVER = ManagementFactory.getPlatformMBeanServer();
    protected Map<String, MBeanServer> servers;
    protected MBeanServer defaultServer = DEFAULT_SERVER;

    public void start(ComponentContext context) {
        this.servers = new HashMap<String, MBeanServer>();
        this.getRegistryContributions(LOCATORS_EXT_KEY).forEach(descriptor -> {
            MBeanServer server = descriptor.isExisting ? this.doFindServer(descriptor.domainName) : this.doCreateServer((ServerLocatorDescriptor)descriptor);
            this.servers.put(descriptor.domainName, server);
            if (descriptor.isDefault) {
                this.defaultServer = server;
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.servers = null;
        this.defaultServer = DEFAULT_SERVER;
    }

    protected MBeanServer doCreateServer(ServerLocatorDescriptor descriptor) {
        RMIConnectorServer connector;
        JMXServiceURL url;
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + descriptor.rmiPort + "/" + descriptor.domainName + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            throw new ManagementRuntimeException("Cannot format url for " + descriptor.domainName);
        }
        if (!descriptor.remote) {
            return server;
        }
        try {
            connector = new RMIConnectorServer(url, null, server);
        }
        catch (IOException e) {
            throw new ManagementRuntimeException("Cannot start connector for " + descriptor.domainName, e);
        }
        try {
            connector.start();
        }
        catch (IOException e) {
            try {
                LocateRegistry.createRegistry(descriptor.rmiPort);
            }
            catch (RemoteException e2) {
                throw new ManagementRuntimeException("Cannot start RMI connector for " + descriptor.domainName, e);
            }
            try {
                connector.start();
            }
            catch (IOException e2) {
                throw new ManagementRuntimeException("Cannot start RMI connector for " + descriptor.domainName, e2);
            }
        }
        assert (connector.isActive());
        log.info("Started a mbean server: {}", (Object)url);
        return server;
    }

    protected MBeanServer doFindServer(String domainName) {
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            String domain = server.getDefaultDomain();
            if (domain == null || !domain.equals(domainName)) continue;
            return server;
        }
        return this.defaultServer;
    }

    @Override
    public MBeanServer lookupServer(ObjectName qualifiedName) {
        if (this.defaultServer.isRegistered(qualifiedName)) {
            return this.defaultServer;
        }
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.isRegistered(qualifiedName)) continue;
            return server;
        }
        throw new ManagementRuntimeException(qualifiedName + " is not registered");
    }

    @Override
    public MBeanServer lookupServer() {
        return this.defaultServer;
    }

    @Override
    public MBeanServer lookupServer(String domainName) {
        return this.doFindServer(domainName);
    }
}

