/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.io.DocumentPipe;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;
import org.nuxeo.ecm.core.io.impl.transformers.PropertyDeprecationRemover;
import org.nuxeo.runtime.api.Framework;

public class DocumentPipeImpl
implements DocumentPipe {
    private final List<DocumentTransformer> transformers;
    private final int pageSize;
    private DocumentReader reader;
    private DocumentWriter writer;

    public DocumentPipeImpl(int pageSize) {
        this.pageSize = pageSize;
        this.transformers = new ArrayList<DocumentTransformer>();
        this.transformers.add(new PropertyDeprecationRemover());
    }

    public DocumentPipeImpl() {
        this(0);
    }

    @Override
    public void addTransformer(DocumentTransformer transformer) {
        this.transformers.add(transformer);
    }

    @Override
    public DocumentReader getReader() {
        return this.reader;
    }

    @Override
    public List<DocumentTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    public DocumentWriter getWriter() {
        return this.writer;
    }

    @Override
    public void removeTransformer(DocumentTransformer transformer) {
        this.transformers.remove(transformer);
    }

    @Override
    public void setReader(DocumentReader reader) {
        this.reader = reader;
    }

    @Override
    public void setWriter(DocumentWriter writer) {
        this.writer = writer;
    }

    @Override
    public DocumentTranslationMap run() throws IOException {
        if (this.reader == null) {
            throw new IllegalArgumentException("Pipe reader cannot be null");
        }
        if (this.writer == null) {
            throw new IllegalArgumentException("Pipe writer cannot be null");
        }
        ArrayList<DocumentTranslationMap> maps = new ArrayList<DocumentTranslationMap>();
        Framework.doPrivilegedThrowing(() -> this.readAndWriteDocs(maps));
        return DocumentTranslationMapImpl.merge(maps);
    }

    protected void handleBatchEnd() {
    }

    protected void readAndWriteDocs(List<DocumentTranslationMap> maps) throws IOException {
        if (this.pageSize == 0) {
            ExportedDocument doc;
            while ((doc = this.reader.read()) != null) {
                this.applyTransforms(doc);
                DocumentTranslationMap map = this.writer.write(doc);
                maps.add(map);
                this.handleBatchEnd();
            }
        } else {
            ExportedDocument[] docs;
            while ((docs = this.reader.read(this.pageSize)) != null) {
                if (docs.length == 0) continue;
                this.applyTransforms(docs);
                DocumentTranslationMap map = this.writer.write(docs);
                if (map != null) {
                    maps.add(map);
                }
                this.handleBatchEnd();
            }
        }
    }

    public void applyTransforms(ExportedDocument doc) throws IOException {
        for (DocumentTransformer tr : this.transformers) {
            tr.transform(doc);
        }
    }

    public void applyTransforms(ExportedDocument[] docs) throws IOException {
        for (DocumentTransformer tr : this.transformers) {
            for (ExportedDocument doc : docs) {
                tr.transform(doc);
            }
        }
    }
}

