/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ChildrenJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "children";

    public ChildrenJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        DocumentModelList children = null;
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            children = wrapper.getSession().getChildren(document.getRef());
        }
        jg.writeFieldName(NAME);
        this.writeEntity(children, jg);
    }
}

