/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.io.registry.Marshaller;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistryDescriptor;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.MarshallerInspector;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class MarshallerRegistryImpl
extends DefaultComponent
implements MarshallerRegistry {
    private static final Logger log = LogManager.getLogger(MarshallerRegistryImpl.class);
    public static final String XP_MARSHALLERS = "marshallers";
    private static final Set<MarshallerInspector> writers = new ConcurrentSkipListSet<MarshallerInspector>();
    private static final Map<MediaType, Set<MarshallerInspector>> writersByMediaType = new ConcurrentHashMap<MediaType, Set<MarshallerInspector>>();
    private static final Set<MarshallerInspector> readers = new ConcurrentSkipListSet<MarshallerInspector>();
    private static final Map<MediaType, Set<MarshallerInspector>> readersByMediaType = new ConcurrentHashMap<MediaType, Set<MarshallerInspector>>();
    private static final Map<Class<?>, MarshallerInspector> marshallersByType = new ConcurrentHashMap();

    public void start(ComponentContext context) {
        this.clear();
        List descriptors = this.getRegistryContributions(XP_MARSHALLERS);
        for (MarshallerRegistryDescriptor descriptor : descriptors) {
            try {
                this.register(Class.forName(descriptor.klass));
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate MarshallerRegistryDescriptor", (Throwable)e);
            }
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.clear();
    }

    @Override
    public void register(Class<?> marshaller) {
        Set<MarshallerInspector> inspectors;
        if (marshaller == null) {
            throw new MarshallingException("Cannot register null marshaller");
        }
        MarshallerInspector inspector = new MarshallerInspector(marshaller);
        if (!inspector.isWriter() && !inspector.isReader()) {
            throw new MarshallingException("The marshaller registry just supports Writer and Reader for now. You have to implement " + Writer.class.getName() + " or " + Reader.class.getName());
        }
        if (marshallersByType.get(marshaller) != null) {
            log.warn("The marshaller {} is already registered.", (Object)marshaller.getName());
            return;
        }
        marshallersByType.put(marshaller, inspector);
        if (inspector.isWriter()) {
            writers.add(inspector);
            for (MediaType mediaType : inspector.getSupports()) {
                inspectors = writersByMediaType.get(mediaType);
                if (inspectors == null) {
                    inspectors = new ConcurrentSkipListSet<MarshallerInspector>();
                    writersByMediaType.put(mediaType, inspectors);
                }
                inspectors.add(inspector);
            }
        }
        if (inspector.isReader()) {
            readers.add(inspector);
            for (MediaType mediaType : inspector.getSupports()) {
                inspectors = readersByMediaType.get(mediaType);
                if (inspectors == null) {
                    inspectors = new ConcurrentSkipListSet<MarshallerInspector>();
                    readersByMediaType.put(mediaType, inspectors);
                }
                inspectors.add(inspector);
            }
        }
    }

    @Override
    public void deregister(Class<?> marshaller) {
        Set<MarshallerInspector> inspectors;
        if (marshaller == null) {
            log.warn("Cannot deregister null marshaller");
            return;
        }
        MarshallerInspector inspector = new MarshallerInspector(marshaller);
        if (!inspector.isWriter() && !inspector.isReader()) {
            throw new MarshallingException("The marshaller registry just supports Writer and Reader for now. You have to implement " + Writer.class.getName() + " or " + Reader.class.getName());
        }
        marshallersByType.remove(marshaller);
        if (inspector.isWriter()) {
            writers.remove(inspector);
            for (MediaType mediaType : inspector.getSupports()) {
                inspectors = writersByMediaType.get(mediaType);
                if (inspectors == null) continue;
                inspectors.remove(inspector);
            }
        }
        if (inspector.isReader()) {
            readers.remove(inspector);
            for (MediaType mediaType : inspector.getSupports()) {
                inspectors = readersByMediaType.get(mediaType);
                if (inspectors == null) continue;
                inspectors.remove(inspector);
            }
        }
    }

    @Override
    public <T> Writer<T> getWriter(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype) {
        Set<MarshallerInspector> candidates = writersByMediaType.get(mediatype);
        return (Writer)this.getMarshaller(ctx, marshalledClazz, genericType, mediatype, candidates, writers, false);
    }

    @Override
    public <T> Writer<T> getUniqueWriter(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype) {
        Set<MarshallerInspector> candidates = writersByMediaType.get(mediatype);
        return (Writer)this.getMarshaller(ctx, marshalledClazz, genericType, mediatype, candidates, writers, true);
    }

    @Override
    public <T> Collection<Writer<T>> getAllWriters(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype) {
        Set<MarshallerInspector> candidates = writersByMediaType.get(mediatype);
        Collection<Marshaller<T>> founds = this.getAllMarshallers(ctx, marshalledClazz, genericType, mediatype, candidates, writers);
        return founds;
    }

    @Override
    public <T> Writer<T> getWriter(RenderingContext ctx, Class<T> marshalledClazz, MediaType mediatype) {
        return this.getWriter(ctx, marshalledClazz, marshalledClazz, mediatype);
    }

    @Override
    public <T> Reader<T> getReader(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype) {
        Set<MarshallerInspector> candidates = readersByMediaType.get(mediatype);
        return (Reader)this.getMarshaller(ctx, marshalledClazz, genericType, mediatype, candidates, readers, false);
    }

    @Override
    public <T> Reader<T> getUniqueReader(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype) {
        Set<MarshallerInspector> candidates = readersByMediaType.get(mediatype);
        return (Reader)this.getMarshaller(ctx, marshalledClazz, genericType, mediatype, candidates, readers, true);
    }

    @Override
    public <T> Collection<Reader<T>> getAllReaders(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype) {
        Set<MarshallerInspector> candidates = readersByMediaType.get(mediatype);
        Collection<Marshaller<T>> founds = this.getAllMarshallers(ctx, marshalledClazz, genericType, mediatype, candidates, readers);
        return founds;
    }

    @Override
    public <T> Reader<T> getReader(RenderingContext ctx, Class<T> marshalledClazz, MediaType mediatype) {
        return this.getReader(ctx, marshalledClazz, marshalledClazz, mediatype);
    }

    public <T> Marshaller<T> getMarshaller(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype, Set<MarshallerInspector> customs, Set<MarshallerInspector> wildcards, boolean forceInstantiation) {
        Marshaller<T> found;
        if (customs != null && (found = this.searchCandidate(ctx, marshalledClazz, genericType, mediatype, customs, forceInstantiation)) != null) {
            return found;
        }
        return this.searchCandidate(ctx, marshalledClazz, genericType, mediatype, wildcards, forceInstantiation);
    }

    public <T> Collection<Marshaller<T>> getAllMarshallers(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype, Set<MarshallerInspector> customs, Set<MarshallerInspector> wildcards) {
        HashMap<MarshallerInspector, Marshaller<T>> result = new HashMap<MarshallerInspector, Marshaller<T>>();
        if (customs != null) {
            result.putAll(this.searchAllCandidates(ctx, marshalledClazz, genericType, mediatype, customs));
        }
        result.putAll(this.searchAllCandidates(ctx, marshalledClazz, genericType, mediatype, wildcards));
        return result.values();
    }

    private <T> Marshaller<T> searchCandidate(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype, Set<MarshallerInspector> candidates, boolean forceInstantiation) {
        for (MarshallerInspector inspector : candidates) {
            if (!inspector.getMarshalledType().isAssignableFrom(marshalledClazz) || genericType != null && !marshalledClazz.equals(inspector.getGenericType()) && !TypeUtils.isAssignable((Type)genericType, (Type)inspector.getGenericType())) continue;
            Marshaller marshaller = null;
            marshaller = forceInstantiation ? (Marshaller)inspector.getNewInstance(ctx, false) : (Marshaller)inspector.getInstance(ctx);
            if (!marshaller.accept(marshalledClazz, genericType, mediatype)) continue;
            return marshaller;
        }
        return null;
    }

    private <T> Map<MarshallerInspector, Marshaller<T>> searchAllCandidates(RenderingContext ctx, Class<T> marshalledClazz, Type genericType, MediaType mediatype, Set<MarshallerInspector> candidates) {
        HashMap<MarshallerInspector, Marshaller<T>> result = new HashMap<MarshallerInspector, Marshaller<T>>();
        for (MarshallerInspector inspector : candidates) {
            Marshaller marshaller;
            if (!inspector.getMarshalledType().isAssignableFrom(marshalledClazz) || genericType != null && !marshalledClazz.equals(inspector.getGenericType()) && !TypeUtils.isAssignable((Type)genericType, (Type)inspector.getGenericType()) || !(marshaller = (Marshaller)inspector.getInstance(ctx)).accept(marshalledClazz, genericType, mediatype)) continue;
            result.put(inspector, marshaller);
        }
        return result;
    }

    @Override
    public <T> T getInstance(RenderingContext ctx, Class<T> marshallerClass) {
        MarshallerInspector inspector = marshallersByType.get(marshallerClass);
        if (inspector == null) {
            inspector = new MarshallerInspector(marshallerClass);
        }
        return inspector.getInstance(ctx);
    }

    @Override
    public <T> T getUniqueInstance(RenderingContext ctx, Class<T> marshallerClass) {
        MarshallerInspector inspector = marshallersByType.get(marshallerClass);
        if (inspector == null) {
            inspector = new MarshallerInspector(marshallerClass);
        }
        Object result = inspector.getNewInstance(ctx, false);
        return (T)result;
    }

    @Override
    public void clear() {
        marshallersByType.clear();
        writersByMediaType.clear();
        readersByMediaType.clear();
        writers.clear();
        readers.clear();
    }
}

