/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.csv.export.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.marshallers.csv.AbstractCSVWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.platform.csv.export.io.DocumentModelCSVHelper;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentPropertyCSVWriter
extends AbstractCSVWriter<Property> {
    public static final String LIST_DELIMITER = " | ";
    public static final String LANG_CTX_DATA = "lang";
    public static final String UNKNOWN_TRANSLATED_VALUE_LABEL = "unknown translated value";

    protected void write(Property property, CSVPrinter printer) throws IOException {
        if (property == null) {
            printer.print(null);
        } else if (property.isScalar()) {
            if (property instanceof BlobProperty.ScalarMemberProperty && property.getParent().getValue() == null) {
                printer.print(null);
                return;
            }
            this.writeScalarProperty(property, printer);
        } else if (property.isList()) {
            this.writeListProperty(property, printer);
        } else {
            this.writeUnsupported(property.getType(), printer);
        }
    }

    protected void writeHeader(Property property, CSVPrinter printer) throws IOException {
        printer.printRecord(new Object[]{property.getXPath()});
    }

    protected void writeScalarProperty(Property property, CSVPrinter printer) throws IOException {
        Serializable value = property.getValue();
        Type type = property.getType();
        if (type instanceof BinaryType) {
            this.writeUnsupported(type, printer);
        } else {
            String valueAsString = null;
            if (value == null) {
                printer.print(null);
            } else {
                valueAsString = type.encode((Object)value);
                printer.print((Object)valueAsString);
            }
            Directory vocabulary = DocumentModelCSVHelper.getVocabulary(type);
            if (vocabulary != null) {
                this.writeScalarVocabularyProperty(valueAsString, vocabulary, printer);
            }
        }
    }

    protected void writeScalarVocabularyProperty(String value, Directory vocabulary, CSVPrinter printer) throws IOException {
        if (value == null) {
            printer.print(null);
        } else {
            try (Session session = vocabulary.getSession();){
                String lang = (String)this.ctx.getParameter(LANG_CTX_DATA);
                printer.print((Object)this.getTranslatedValue(session, vocabulary.getSchema(), lang, value));
            }
        }
    }

    protected void writeListProperty(Property property, CSVPrinter printer) throws IOException {
        ListType type = (ListType)property.getType();
        if (property instanceof ArrayProperty) {
            Object[] array = (Object[])property.getValue();
            Type itemType = type.getFieldType();
            Directory vocabulary = DocumentModelCSVHelper.getVocabulary(itemType);
            if (array == null) {
                printer.print(null);
                if (vocabulary != null) {
                    printer.print(null);
                }
                return;
            }
            if (itemType instanceof BinaryType) {
                this.writeUnsupported((Type)type, printer);
            } else {
                String value = Arrays.stream(array).map(arg_0 -> ((Type)itemType).encode(arg_0)).collect(Collectors.joining(LIST_DELIMITER));
                printer.print((Object)value);
                if (vocabulary != null) {
                    String[] values = (String[])Arrays.stream(array).map(arg_0 -> ((Type)itemType).encode(arg_0)).toArray(String[]::new);
                    this.writeListVocabularyProperty(values, vocabulary, printer);
                }
            }
        } else {
            this.writeUnsupported((Type)type, printer);
        }
    }

    protected void writeListVocabularyProperty(String[] values, Directory vocabulary, CSVPrinter printer) throws IOException {
        ArrayList<String> translated = new ArrayList<String>();
        try (Session session = vocabulary.getSession();){
            String lang = (String)this.ctx.getParameter(LANG_CTX_DATA);
            for (String value : values) {
                translated.add(this.getTranslatedValue(session, vocabulary.getSchema(), lang, value));
            }
        }
        printer.print((Object)String.join((CharSequence)LIST_DELIMITER, translated));
    }

    protected String getTranslatedValue(Session session, String schema, String lang, String value) {
        String label;
        DocumentModel entry;
        if (value.contains("/")) {
            value = value.substring(value.lastIndexOf("/") + 1);
        }
        if ((entry = session.getEntry(value)) == null) {
            return UNKNOWN_TRANSLATED_VALUE_LABEL;
        }
        try {
            label = (String)entry.getProperty(schema, "label");
        }
        catch (PropertyNotFoundException e) {
            try {
                return (String)entry.getProperty(schema, "label_en");
            }
            catch (PropertyNotFoundException e1) {
                return value;
            }
        }
        Locale locale = lang != null ? Locale.forLanguageTag(lang) : this.ctx.getLocale();
        return I18NUtils.getMessageString((String)"messages", (String)label, (Object[])new Object[0], (Locale)locale);
    }

    protected void writeUnsupported(Type type, CSVPrinter printer) throws IOException {
        printer.print((Object)String.format("type %s is not supported", type.getName()));
    }
}

