/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation.internals;

import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.ComputationMetadataMapping;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.log.LogOffset;

public class ComputationContextImpl
implements ComputationContext {
    protected final ComputationMetadataMapping metadata;
    protected final Map<String, List<Record>> streamRecords;
    protected final Map<String, Long> timers;
    protected final StreamManager manager;
    protected final ComputationPolicy policy;
    protected final boolean isSpare;
    protected boolean checkpointFlag;
    protected long lowWatermark;
    protected boolean terminateFlag;
    protected LogOffset lastOffset;

    public ComputationContextImpl(StreamManager streamManager, ComputationMetadataMapping metadata, ComputationPolicy policy, boolean isSpare) {
        this.manager = streamManager;
        this.metadata = metadata;
        this.timers = new HashMap<String, Long>();
        this.streamRecords = new HashMap<String, List<Record>>();
        this.policy = policy;
        this.isSpare = isSpare;
    }

    public ComputationContextImpl(StreamManager streamManager, ComputationMetadataMapping metadata, ComputationPolicy policy) {
        this(streamManager, metadata, policy, false);
    }

    public ComputationContextImpl(ComputationMetadataMapping computationMetadataMapping) {
        this(null, computationMetadataMapping, ComputationPolicy.NONE, false);
    }

    public List<Record> getRecords(String streamName) {
        return this.streamRecords.getOrDefault(streamName, Collections.emptyList());
    }

    public Map<String, Long> getTimers() {
        return this.timers;
    }

    @Override
    public void setTimer(String key, long time) {
        Objects.requireNonNull(key);
        this.timers.put(key, time);
    }

    public void removeTimer(String key) {
        Objects.requireNonNull(key);
        this.timers.remove(key);
    }

    @Override
    public void produceRecord(String streamName, Record record) {
        String targetStream = this.metadata.map(streamName);
        if (!this.metadata.outputStreams().contains(targetStream)) {
            throw new IllegalArgumentException("Stream: " + targetStream + " not registered as output of: " + this.metadata);
        }
        this.streamRecords.computeIfAbsent(targetStream, key -> new ArrayList()).add(record);
    }

    public LogOffset produceRecordImmediate(String streamName, Record record) {
        Tracing.getTracer().getCurrentSpan().addAnnotation("Produce record immediate " + record.getKey());
        if (this.manager == null) {
            throw new IllegalStateException("No logManager provided in context");
        }
        String targetStream = this.metadata.map(streamName);
        if (!this.metadata.outputStreams().contains(targetStream)) {
            throw new IllegalArgumentException("Stream not registered as output: " + targetStream + ":" + streamName);
        }
        return this.manager.append(targetStream, record);
    }

    public void produceRecordImmediate(String streamName, String key, byte[] data) {
        this.produceRecordImmediate(streamName, Record.of(key, data));
    }

    @Override
    public LogOffset getLastOffset() {
        return this.lastOffset;
    }

    @Override
    public ComputationPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public boolean isSpareComputation() {
        return this.isSpare;
    }

    public void setLastOffset(LogOffset lastOffset) {
        this.lastOffset = lastOffset;
    }

    public long getSourceLowWatermark() {
        return this.lowWatermark;
    }

    @Override
    public void setSourceLowWatermark(long watermark) {
        this.lowWatermark = watermark;
    }

    public boolean requireCheckpoint() {
        return this.checkpointFlag;
    }

    public void removeCheckpointFlag() {
        this.checkpointFlag = false;
    }

    @Override
    public void askForCheckpoint() {
        this.checkpointFlag = true;
    }

    @Override
    public void cancelAskForCheckpoint() {
        this.checkpointFlag = false;
    }

    @Override
    public void askForTermination() {
        this.terminateFlag = true;
    }

    public boolean requireTerminate() {
        return this.terminateFlag;
    }

    public String toString() {
        return "ComputationContextImpl{metadata=" + this.metadata + ", streamRecords=" + this.streamRecords + ", timers=" + this.timers + ", manager=" + this.manager + ", policy=" + this.policy + ", isSpare=" + this.isSpare + ", checkpointFlag=" + this.checkpointFlag + ", lowWatermark=" + this.lowWatermark + ", terminateFlag=" + this.terminateFlag + ", lastOffset=" + this.lastOffset + "}";
    }
}

