/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogConfig;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogOffsetTracker;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogTailer;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionListener;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;
import org.nuxeo.lib.stream.log.internals.LogOffsetImpl;

public class ChronicleLogAppender<M extends Externalizable>
implements CloseableLogAppender<M> {
    private static final Log log = LogFactory.getLog(ChronicleLogAppender.class);
    protected static final String PARTITION_PREFIX = "P-";
    protected static final String METADATA_FILE = "metadata.properties";
    protected static final int POLL_INTERVAL_MS = 100;
    protected static final int MAX_PARTITIONS = 100;
    public static final String MSG_KEY = "msg";
    public static final int CQ_BLOCK_SIZE = 0x400000;
    public static final String RETENTION_KEY = "retention";
    public static final String PARTITIONS_KEY = "partitions";
    public static final String BLOCK_SIZE_KEY = "blockSize";
    protected final List<ChronicleQueue> partitions;
    protected final int nbPartitions;
    protected final File basePath;
    protected final int blockSize;
    protected final Name name;
    protected final ConcurrentLinkedQueue<ChronicleLogTailer<M>> tailers = new ConcurrentLinkedQueue();
    protected final ChronicleRetentionDuration retention;
    protected final Codec<M> codec;
    protected volatile boolean closed;

    protected ChronicleLogAppender(ChronicleLogConfig config, Name name, Codec<M> codec, boolean withRetention) {
        this.basePath = config.getBasePath().resolve(name.getId()).toFile();
        if (!ChronicleLogAppender.exists(this.basePath)) {
            throw new IllegalArgumentException("Cannot open Chronicle Log, invalid path: " + this.basePath);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening: " + this.toString()));
        }
        Objects.requireNonNull(codec);
        this.codec = codec;
        this.name = name;
        Path metadataPath = this.getMetadataPath();
        if (!metadataPath.toFile().exists()) {
            throw new IllegalArgumentException(String.format("Cannot open Log %s: no metadata file %s", this.name, metadataPath));
        }
        Properties metadata = ChronicleLogAppender.readMetadata(this.getMetadataPath());
        if (!withRetention) {
            this.retention = ChronicleRetentionDuration.disableOf(config.getRetention());
        } else {
            ChronicleRetentionDuration storedRetention = new ChronicleRetentionDuration(metadata.getProperty(RETENTION_KEY));
            if (config.getRetention().getRollCycle() != storedRetention.getRollCycle()) {
                throw new IllegalArgumentException(String.format("Cannot open Log %s: expecting retention: %s got: %s", this.name, storedRetention, config.getRetention()));
            }
            this.retention = config.getRetention();
        }
        this.nbPartitions = Integer.parseInt(metadata.getProperty(PARTITIONS_KEY));
        this.blockSize = Integer.parseInt(metadata.getProperty(BLOCK_SIZE_KEY));
        this.partitions = new ArrayList<ChronicleQueue>(this.nbPartitions);
        this.initPartitions(false);
    }

    protected ChronicleLogAppender(ChronicleLogConfig config, Name name, int size, Codec<M> codec) {
        if (size <= 0) {
            throw new IllegalArgumentException("Number of partitions must be > 0");
        }
        this.basePath = config.getBasePath().resolve(name.getId()).toFile();
        if (size > 100) {
            throw new IllegalArgumentException(String.format("Cannot create more than: %d partitions for log: %s, requested: %d", 100, this.basePath, size));
        }
        if (ChronicleLogAppender.exists(this.basePath)) {
            throw new IllegalArgumentException("Cannot create Chronicle Queues, already exists: " + this.basePath);
        }
        if (!this.basePath.exists() && !this.basePath.mkdirs()) {
            throw new IllegalArgumentException("Invalid path to create Chronicle Queues: " + this.basePath);
        }
        Objects.requireNonNull(codec);
        this.nbPartitions = size;
        this.codec = codec;
        this.retention = config.getRetention();
        this.partitions = new ArrayList<ChronicleQueue>(this.nbPartitions);
        this.name = name;
        this.blockSize = 0x400000;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating: " + this.toString()));
        }
        this.initPartitions(true);
        this.saveMetadata();
    }

    protected void initPartitions(boolean create) {
        for (int i = 0; i < this.nbPartitions; ++i) {
            Path partitionPath = this.basePath.toPath().resolve(String.format("%s%02d", PARTITION_PREFIX, i));
            if (create) {
                try {
                    Files.createDirectories(partitionPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot create directory: " + partitionPath.toAbsolutePath(), e);
                }
            }
            ChronicleRetentionListener listener = null;
            SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((Path)partitionPath).rollCycle(this.retention.getRollCycle()).blockSize(this.blockSize);
            if (!this.retention.disable()) {
                listener = new ChronicleRetentionListener(this.retention);
                builder.storeFileListener((StoreFileListener)listener);
            }
            SingleChronicleQueue queue = builder.build();
            this.partitions.add((ChronicleQueue)queue);
            if (listener == null) continue;
            listener.setQueue(queue);
        }
    }

    protected void saveMetadata() {
        Path metadata = this.getMetadataPath();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("# Log created %s%n", Instant.now().toString()));
        builder.append(String.format("%s=%d%n", PARTITIONS_KEY, this.nbPartitions));
        builder.append(String.format("%s=%s%n", RETENTION_KEY, this.retention));
        builder.append(String.format("%s=%d%n", BLOCK_SIZE_KEY, this.blockSize));
        try {
            Files.write(metadata, builder.toString().getBytes(), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to create metadata file: " + metadata, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Created Log: %s%n%s", this.name, builder.toString()), new Throwable("here"));
        }
    }

    protected Path getMetadataPath() {
        return this.basePath.toPath().resolve(METADATA_FILE);
    }

    protected static Properties readMetadata(Path file) {
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            props.load(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot open Log metadata file: " + file, e);
        }
        return props;
    }

    protected static boolean exists(File basePath) {
        return basePath.isDirectory() && basePath.list().length > 0;
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> create(ChronicleLogConfig config, Name name, int size, Codec<M> codec) {
        return new ChronicleLogAppender<M>(config, name, size, codec);
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> open(ChronicleLogConfig config, Name name, Codec<M> codec) {
        return new ChronicleLogAppender<M>(config, name, codec, true);
    }

    public static <M extends Externalizable> ChronicleLogAppender<M> openWithoutRetention(ChronicleLogConfig config, Name name, Codec<M> codec) {
        return new ChronicleLogAppender<M>(config, name, codec, false);
    }

    public String getBasePath() {
        return this.basePath.getPath();
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.nbPartitions;
    }

    @Override
    public LogOffset append(int partition, M message) {
        ExcerptAppender appender = this.partitions.get(partition).acquireAppender();
        try {
            if (NoCodec.NO_CODEC.equals(this.codec)) {
                appender.writeDocument(w -> w.write((CharSequence)MSG_KEY).object(message));
            } else {
                appender.writeDocument(w -> w.write().bytes(this.codec.encode(message)));
            }
        }
        catch (DecoratedBufferOverflowException e) {
            throw new StreamRuntimeException(e);
        }
        long offset = appender.lastIndexAppended();
        LogOffsetImpl ret = new LogOffsetImpl(this.name, partition, offset);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("append to %s, value: %s", ret, message));
        }
        return ret;
    }

    public LogTailer<M> createTailer(LogPartition partition, Name group, Codec<M> codec) {
        return this.addTailer(new ChronicleLogTailer<M>(codec, this.basePath.toString(), this.partitions.get(partition.partition()).createTailer(), partition, group, this.retention));
    }

    public long endOffset(int partition) {
        try (ExcerptTailer tailer = this.partitions.get(partition).createTailer().toEnd();){
            long l = tailer.index();
            return l;
        }
    }

    public long firstOffset(int partition) {
        long ret = this.partitions.get(partition).firstIndex();
        if (ret == Long.MAX_VALUE) {
            return 0L;
        }
        return ret;
    }

    public long countMessages(int partition, long lowerOffset, long upperOffset) {
        long ret;
        SingleChronicleQueue queue = (SingleChronicleQueue)this.partitions.get(partition);
        try {
            ret = queue.countExcerpts(lowerOffset, upperOffset);
        }
        catch (IllegalStateException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Missing low cycle file: " + lowerOffset + " for queue: " + queue + " " + e.getMessage()));
            }
            return 0L;
        }
        return ret;
    }

    protected LogTailer<M> addTailer(ChronicleLogTailer<M> tailer) {
        this.tailers.add(tailer);
        return tailer;
    }

    @Override
    public boolean waitFor(LogOffset offset, Name group, Duration timeout) throws InterruptedException {
        boolean ret;
        long offsetPosition = offset.offset();
        int partition = offset.partition().partition();
        try (ChronicleLogOffsetTracker offsetTracker = new ChronicleLogOffsetTracker(this.basePath.toString(), partition, group, ChronicleRetentionDuration.disableOf(this.retention));){
            ret = this.isProcessed(offsetTracker, offsetPosition);
            if (ret) {
                boolean bl = true;
                return bl;
            }
            long timeoutMs = timeout.toMillis();
            long deadline = System.currentTimeMillis() + timeoutMs;
            long delay = Math.min(100L, timeoutMs);
            while (!ret && System.currentTimeMillis() < deadline) {
                Thread.sleep(delay);
                ret = this.isProcessed(offsetTracker, offsetPosition);
            }
        }
        return ret;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    public Codec<M> getCodec() {
        return this.codec;
    }

    protected boolean isProcessed(ChronicleLogOffsetTracker tracker, long offset) {
        long last = tracker.readLastCommittedOffset();
        return last > 0L && last >= offset;
    }

    @Override
    public void close() {
        log.debug((Object)("Closing: " + this.toString()));
        this.tailers.stream().filter(Objects::nonNull).forEach(ChronicleLogTailer::close);
        this.tailers.clear();
        this.partitions.stream().filter(Objects::nonNull).forEach(Closeable::close);
        this.partitions.clear();
        this.closed = true;
    }

    public static int partitions(Path basePath) {
        Path metadataPath = basePath.resolve(METADATA_FILE);
        if (!metadataPath.toFile().exists()) {
            throw new IllegalArgumentException("No CQ file on " + basePath);
        }
        return Integer.parseInt(ChronicleLogAppender.readMetadata(metadataPath).getProperty(PARTITIONS_KEY));
    }

    public static int discoverPartitions(Path basePath) {
        int n;
        block9: {
            Stream<Path> paths = Files.list(basePath);
            try {
                int ret = (int)paths.filter(ChronicleLogAppender::isPartitionDirectory).count();
                if (ret == 0) {
                    throw new IOException("No chronicles queues file found");
                }
                n = ret;
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid basePath for queue: " + basePath, e);
                }
            }
            paths.close();
        }
        return n;
    }

    protected static boolean isPartitionDirectory(Path path) {
        return path.toFile().isDirectory() && path.getFileName().toString().startsWith(PARTITION_PREFIX);
    }

    public String toString() {
        return "ChronicleLogAppender{nbPartitions=" + this.nbPartitions + ", basePath=" + this.basePath + ", name='" + this.name + "', retention=" + this.retention + ", closed=" + this.closed + ", codec=" + this.codec + "}";
    }

    public ChronicleRetentionDuration getRetention() {
        return this.retention;
    }
}

