/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.w3c.dom.Element;

public class FileManagerRegistry
implements Registry {
    protected Map<String, MapRegistry> registries = new ConcurrentHashMap<String, MapRegistry>();

    public void initialize() {
        this.registries.values().forEach(MapRegistry::initialize);
    }

    public void tag(String id) {
        this.registries.values().forEach(r -> r.tag(id));
    }

    public boolean isTagged(String id) {
        return this.registries.values().stream().anyMatch(r -> r.isTagged(id));
    }

    protected String computePluginsExtensionPoint(Class<?> klass) {
        return String.format("%s-%s", "plugins", klass.getSimpleName());
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        String rid = this.computePluginsExtensionPoint(xObject.getKlass());
        this.registries.computeIfAbsent(rid, k -> new MapRegistry()).register(ctx, xObject, element, tag);
    }

    public void unregister(String tag) {
        this.registries.values().stream().filter(r -> r.isTagged(tag)).forEach(r -> r.unregister(tag));
    }

    public <T> List<T> getContributionValues(Class<?> klass) {
        String rid = this.computePluginsExtensionPoint(klass);
        MapRegistry registry = this.registries.get(rid);
        return registry == null ? List.of() : registry.getContributionValues();
    }
}

