/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.service.FileManagerService;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractFileImporter
implements FileImporter {
    private static final long serialVersionUID = 1L;
    protected String name = "";
    protected String docType;
    protected transient List<String> filters = new ArrayList<String>();
    protected transient List<Pattern> patterns;
    protected boolean enabled = true;
    protected Integer order = 0;
    public static final String SKIP_UPDATE_AUDIT_LOGGING = "org.nuxeo.filemanager.skip.audit.logging.forupdates";
    public static final String DISABLE_AUDIT_LOGGER = "disableAuditLogger";
    @Deprecated(since="10.3")
    protected transient FileManagerService fileManagerService = (FileManagerService)Framework.getService(FileManager.class);

    protected AbstractFileImporter() {
    }

    @Override
    public List<String> getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(List<String> filters) {
        this.filters = filters;
        this.patterns = new ArrayList<Pattern>();
        for (String filter : filters) {
            this.patterns.add(Pattern.compile(filter));
        }
    }

    @Override
    public boolean matches(String mimeType) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(mimeType).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDocType() {
        return this.docType;
    }

    @Override
    public void setDocType(String docType) {
        this.docType = docType;
    }

    protected String getDocType(DocumentModel container) {
        return this.getDocType();
    }

    protected String getDefaultDocType() {
        throw new UnsupportedOperationException();
    }

    protected boolean isOverwriteByTitle() {
        throw new UnsupportedOperationException();
    }

    protected void createDocument(DocumentModel doc, String title) {
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
    }

    protected boolean updateDocumentIfPossible(DocumentModel doc, Blob content) {
        this.updateDocument(doc, content);
        return true;
    }

    protected void updateDocument(DocumentModel doc, Blob content) {
        ((BlobHolder)doc.getAdapter(BlobHolder.class)).setBlob(content);
    }

    protected Blob getBlob(DocumentModel doc) {
        return ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
    }

    @Override
    public boolean isOneToMany() {
        return false;
    }

    @Override
    public DocumentModel create(CoreSession session, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws IOException {
        FileImporterContext context = FileImporterContext.builder(session, content, path).overwrite(overwrite).fileName(fullname).build();
        return this.createOrUpdate(context);
    }

    @Override
    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        String path;
        CoreSession session = context.getSession();
        DocumentModel container = session.getDocument((DocumentRef)new PathRef(path = this.getNearestContainerPath(session, context.getParentPath())));
        String targetDocType = this.getDocType(container);
        if (targetDocType == null) {
            targetDocType = this.getDefaultDocType();
        }
        this.checkSecurity(session, path);
        if (!context.isBypassAllowedSubtypeCheck()) {
            this.checkAllowedSubtypes(session, path, targetDocType);
        }
        Blob blob = context.getBlob();
        String filename = FileManagerUtils.fetchFileName(context.getFileName());
        String title = FileManagerUtils.fetchTitle(filename);
        blob.setFilename(filename);
        DocumentModel doc = this.isOverwriteByTitle() ? FileManagerUtils.getExistingDocByTitle(session, path, title) : FileManagerUtils.getExistingDocByFileName(session, path, filename);
        if (context.isOverwrite() && doc != null) {
            BlobProvider blobProvider;
            Blob previousBlob = this.getBlob(doc);
            if (previousBlob != null && (blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(previousBlob)) != null && !blobProvider.supportsUserUpdate()) {
                throw new DocumentSecurityException("Cannot overwrite blob");
            }
            boolean isDocumentUpdated = this.updateDocumentIfPossible(doc, blob);
            if (!isDocumentUpdated) {
                return null;
            }
            if (Framework.isBooleanPropertyTrue((String)SKIP_UPDATE_AUDIT_LOGGING)) {
                doc.putContextData(DISABLE_AUDIT_LOGGER, (Serializable)Boolean.valueOf(true));
            }
            if (context.isPersistDocument()) {
                doc.putContextData("source", (Serializable)((Object)("fileimporter-" + this.getName())));
                doc = doc.getCoreSession().saveDocument(doc);
                session.save();
            }
        } else {
            doc = session.createDocumentModel(targetDocType);
            this.createDocument(doc, title);
            PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            doc.setPathInfo(path, pss.generatePathSegment(doc));
            this.updateDocument(doc, blob);
            if (context.isPersistDocument()) {
                doc.putContextData("source", (Serializable)((Object)("fileimporter-" + this.getName())));
                doc = session.createDocument(doc);
                session.save();
            }
        }
        return doc;
    }

    @Deprecated(since="9.1")
    protected boolean skipCheckInForBlob(Blob blob) {
        return blob == null || blob.getLength() == 0L;
    }

    @Deprecated(since="10.3")
    public FileManagerService getFileManagerService() {
        return this.fileManagerService;
    }

    @Override
    @Deprecated(since="10.3")
    public void setFileManagerService(FileManagerService fileManagerService) {
        this.fileManagerService = fileManagerService;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public int compareTo(FileImporter other) {
        Integer otherOrder = other.getOrder();
        if (this.order == null && otherOrder == null) {
            return 0;
        }
        if (this.order == null) {
            return 1;
        }
        if (otherOrder == null) {
            return -1;
        }
        return this.order.compareTo(otherOrder);
    }

    protected String getNearestContainerPath(CoreSession documentManager, String path) {
        DocumentModel currentDocument = documentManager.getDocument((DocumentRef)new PathRef(path));
        if (!currentDocument.isFolder()) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        return path;
    }

    @Deprecated(since="9.1")
    protected void checkIn(DocumentModel doc) {
        VersioningOption option = this.fileManagerService.getVersioningOption();
        if (option != null && option != VersioningOption.NONE && doc.isCheckedOut()) {
            doc.checkIn(option, null);
        }
    }

    @Deprecated(since="9.1")
    protected void checkInAfterAdd(DocumentModel doc) {
        if (this.fileManagerService.doVersioningAfterAdd()) {
            this.checkIn(doc);
        }
    }

    @Deprecated
    protected void doSecurityCheck(CoreSession documentManager, String path, String typeName) {
        this.doSecurityCheck(documentManager, path, typeName, (TypeManager)Framework.getService(TypeManager.class));
    }

    @Deprecated
    protected void doSecurityCheck(CoreSession documentManager, String path, String typeName, TypeManager typeService) {
        PathRef containerRef = new PathRef(path);
        if (!documentManager.hasPermission((DocumentRef)containerRef, "ReadProperties") || !documentManager.hasPermission((DocumentRef)containerRef, "AddChildren")) {
            throw new DocumentSecurityException("Not enough rights to create folder");
        }
        DocumentModel container = documentManager.getDocument((DocumentRef)containerRef);
        Type containerType = typeService.getType(container.getType());
        if (containerType == null) {
            return;
        }
        if (!typeService.isAllowedSubType(typeName, container.getType(), container)) {
            throw new NuxeoException(String.format("Cannot create document of type %s in container with type %s", typeName, containerType.getId()));
        }
    }

    protected void checkSecurity(CoreSession session, String path) {
        PathRef containerRef = new PathRef(path);
        if (!session.hasPermission((DocumentRef)containerRef, "AddChildren")) {
            throw new DocumentSecurityException("Not enough rights to create document");
        }
    }

    protected void checkAllowedSubtypes(CoreSession session, String path, String typeName) {
        PathRef containerRef = new PathRef(path);
        DocumentModel container = session.getDocument((DocumentRef)containerRef);
        TypeManager typeService = (TypeManager)Framework.getService(TypeManager.class);
        Type containerType = typeService.getType(container.getType());
        if (containerType == null) {
            return;
        }
        if (!typeService.isAllowedSubType(typeName, container.getType(), container)) {
            throw new NuxeoException(String.format("Cannot create document of type %s in container with type %s", typeName, containerType.getId()));
        }
    }
}

