/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.lib.stream.codec.AvroMessageCodec;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

public class StreamMetricsComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(StreamMetricsComputation.class);
    protected static final String NAME = "stream/metrics";
    protected MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"org.nuxeo.runtime.metrics.MetricsService");
    protected final long intervalMs;
    protected final List<String> inputStreams;
    protected final List<Name> streams = new ArrayList<Name>();
    protected final Set<Name> invalidStreams = new HashSet<Name>();
    protected final List<LogPartitionGroup> groups = new ArrayList<LogPartitionGroup>();
    protected final List<LatencyMetric> metrics = new ArrayList<LatencyMetric>();
    protected org.nuxeo.lib.stream.log.LogManager manager;
    protected final Codec<Record> codec = new AvroMessageCodec(Record.class);
    protected long refreshGroupCounter;

    public StreamMetricsComputation(Duration interval, List<String> streams) {
        super(NAME, 1, 0);
        this.intervalMs = interval.toMillis();
        this.inputStreams = streams;
    }

    public void init(ComputationContext context) {
        if (context.isSpareComputation()) {
            log.info("Spare instance nothing to report");
            this.unregisterMetrics();
        } else {
            log.warn("Instance elected to report stream metrics");
            context.setTimer("tracker", System.currentTimeMillis() + this.intervalMs);
        }
    }

    public void destroy() {
        this.unregisterMetrics();
    }

    protected void registerMetrics() {
        this.unregisterMetrics();
        this.getGroups().forEach(group -> this.metrics.add(new LatencyMetric((LogPartitionGroup)group, this.registry)));
    }

    protected void unregisterMetrics() {
        this.metrics.forEach(LatencyMetric::destroy);
        this.metrics.clear();
    }

    public void processTimer(ComputationContext context, String key, long timestamp) {
        this.refreshMetricsIfNeeded();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.metrics::size;
        log.debug("start update metrics: {}", supplierArray);
        List<LatencyMetric> toRemove = this.metrics.stream().filter(metric -> metric.update(this.getManager(), this.codec)).collect(Collectors.toList());
        toRemove.forEach(LatencyMetric::destroy);
        toRemove.forEach(metric -> this.invalidStreams.add(metric.getStream()));
        this.metrics.removeAll(toRemove);
        context.setTimer("tracker", System.currentTimeMillis() + this.intervalMs);
    }

    protected void refreshMetricsIfNeeded() {
        if (this.streams.isEmpty() || this.groups.isEmpty() || this.metrics.isEmpty() || ++this.refreshGroupCounter % 5L == 0L) {
            this.streams.clear();
            this.groups.clear();
            this.registerMetrics();
        }
    }

    protected List<Name> getStreams() {
        if (this.streams.isEmpty()) {
            if (this.inputStreams == null || this.inputStreams.isEmpty()) {
                this.streams.addAll(this.getManager().listAllNames());
                log.debug("Use all available streams: {}", this.streams);
            } else {
                this.inputStreams.forEach(stream -> this.streams.add(Name.ofUrn((String)stream)));
                log.debug("Use input streams: {}", this.streams);
            }
            if (!this.invalidStreams.isEmpty()) {
                this.streams.removeAll(this.invalidStreams);
                log.debug("Filtered list of streams: {}", this.streams);
            }
        }
        return this.streams;
    }

    protected List<LogPartitionGroup> getGroups() {
        if (this.groups.isEmpty()) {
            this.getStreams().forEach(name -> this.getManager().listConsumerGroups(name).forEach(group -> this.groups.add(new LogPartitionGroup(group, name, 0))));
            log.info("Update list of consumers: {}", this.groups);
        }
        return this.groups;
    }

    protected org.nuxeo.lib.stream.log.LogManager getManager() {
        if (this.manager == null) {
            this.manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager();
        }
        return this.manager;
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
    }

    public static class LatencyMetric {
        public static final Object PREFIX = "nuxeo.streams.global.stream.group.";
        protected final LogPartitionGroup consumer;
        protected final MetricRegistry registry;
        protected final MetricName endMetric;
        protected final MetricName posMetric;
        protected final MetricName lagMetric;
        protected final MetricName latMetric;
        protected Latency latency;
        protected boolean registered;

        public LatencyMetric(LogPartitionGroup consumer, MetricRegistry registry) {
            this.consumer = consumer;
            this.registry = registry;
            this.endMetric = this.getMetricName("end");
            this.posMetric = this.getMetricName("pos");
            this.lagMetric = this.getMetricName("lag");
            this.latMetric = this.getMetricName("latency");
        }

        protected MetricName getMetricName(String name) {
            return MetricName.build((String[])new String[]{PREFIX + name}).tagged(new String[]{"stream", this.consumer.name.getId()}).tagged(new String[]{"group", this.consumer.group.getId()});
        }

        protected void registerMetrics() {
            this.registry.register(this.endMetric, (Metric)((Gauge)() -> this.latency.lag().upper()));
            this.registry.register(this.posMetric, (Metric)((Gauge)() -> this.latency.lag().lower()));
            this.registry.register(this.lagMetric, (Metric)((Gauge)() -> this.latency.lag().lag()));
            this.registry.register(this.latMetric, (Metric)((Gauge)() -> this.latency.latency()));
        }

        protected void unregisterMetrics() {
            this.registry.remove(this.endMetric);
            this.registry.remove(this.posMetric);
            this.registry.remove(this.lagMetric);
            this.registry.remove(this.latMetric);
        }

        public boolean update(org.nuxeo.lib.stream.log.LogManager manager, Codec<Record> codec) {
            try {
                this.latency = manager.getLatency(this.consumer.name, this.consumer.group, codec, rec -> Watermark.ofValue((long)rec.getWatermark()).getTimestamp(), Record::getKey);
                if (!this.registered) {
                    this.registerMetrics();
                    this.registered = true;
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClassNotFoundException || e.getCause() instanceof ClassCastException || e instanceof IllegalStateException || e instanceof IllegalArgumentException) {
                    log.warn("Invalid stream, cannot get latency: " + this.consumer, (Throwable)e);
                    return true;
                }
                throw e;
            }
            return false;
        }

        public void destroy() {
            this.unregisterMetrics();
        }

        public Name getStream() {
            return this.consumer.getLogPartition().name();
        }
    }
}

