/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.adapter;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.io.WorkflowRequest;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="workflow", type="workflowAdapter")
public class WorkflowAdapter
extends DefaultAdapter {
    public static final String NAME = "workflow";

    @POST
    public Response doPost(WorkflowRequest routingRequest) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        CoreSession session = doc.getCoreSession();
        String workflowModelName = routingRequest.getWorkflowModelName();
        DocumentRoutingService documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        if (documentRoutingService.canCreateInstance(session, List.of(doc.getId()), workflowModelName)) {
            String workflowInstanceId = documentRoutingService.createNewInstance(workflowModelName, List.of(doc.getId()), routingRequest.getVariables(), session, true);
            DocumentModel result = session.getDocument((DocumentRef)new IdRef(workflowInstanceId));
            DocumentRoute route = (DocumentRoute)result.getAdapter(DocumentRoute.class);
            return Response.ok((Object)route).status(Response.Status.CREATED).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    public List<DocumentRoute> doGet() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        return ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getDocumentRelatedWorkflows(doc, this.getContext().getCoreSession());
    }

    @GET
    @Path(value="{workflowInstanceId}/task")
    public List<Task> doGetTasks(@PathParam(value="workflowInstanceId") String workflowInstanceId) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        return ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getTasks(doc, null, workflowInstanceId, null, this.getContext().getCoreSession());
    }
}

