/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.BulkAdminServiceImpl;
import org.nuxeo.ecm.core.bulk.computation.BulkScrollerComputation;
import org.nuxeo.ecm.core.bulk.computation.BulkStatusComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class BulkServiceProcessor
implements StreamProcessorTopology {
    public Topology getTopology(Map<String, String> options) {
        ArrayList<String> mapping = new ArrayList<String>();
        mapping.add("i1:bulk/command");
        BulkAdminService actionService = (BulkAdminService)Framework.getService(BulkAdminService.class);
        List<String> actions = actionService.getActions();
        int i = 1;
        for (String action : actions) {
            mapping.add(String.format("o%s:%s", i, actionService.getInputStream(action)));
            ++i;
        }
        mapping.add(String.format("o%s:%s", i, "bulk/status"));
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        int scrollBatchSize = confService.getInteger("nuxeo.core.bulk.scroller.scroll.size", 100);
        int scrollKeepAlive = confService.getInteger("nuxeo.core.bulk.scroller.scroll.keepAliveSeconds", 60);
        Duration transactionTimeout = confService.getDuration("nuxeo.core.bulk.scroller.transactionTimeout", BulkAdminServiceImpl.DEFAULT_SCROLL_TRANSACTION_TIMEOUT);
        boolean scrollProduceImmediate = confService.isBooleanTrue("nuxeo.core.bulk.scroller.produceImmediate");
        int scrollProduceImmediateThreshold = confService.getInteger("nuxeo.core.bulk.scroller.produceImmediateThreshold").orElse(1000000);
        return Topology.builder().addComputation(() -> BulkScrollerComputation.builder("bulk/scroller", actions.size() + 1).setScrollBatchSize(scrollBatchSize).setScrollKeepAliveSeconds(scrollKeepAlive).setTransactionTimeout(transactionTimeout).setProduceImmediate(scrollProduceImmediate).setProduceImmediateThreshold(scrollProduceImmediateThreshold).build(), mapping).addComputation(() -> new BulkStatusComputation("bulk/status"), Arrays.asList("i1:bulk/status", "o1:bulk/done")).build();
    }
}

