/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RemoveProxyAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "removeProxy";
    public static final String ACTION_FULL_NAME = "bulk/removeProxy";
    public static final String QUERY_TEMPLATE = "SELECT ecm:uuid FROM Document WHERE ecm:isProxy=1 AND ecm:uuid IN ('%s')";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(RemoveProxyComputation::new, Arrays.asList("i1:bulk/removeProxy", "o1:bulk/status")).build();
    }

    public static class RemoveProxyComputation
    extends AbstractBulkComputation {
        public RemoveProxyComputation() {
            super(RemoveProxyAction.ACTION_FULL_NAME);
        }

        @Override
        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            String query = String.format(RemoveProxyAction.QUERY_TEMPLATE, String.join((CharSequence)"', '", ids));
            HashSet<IdRef> proxies = new HashSet<IdRef>();
            try (IterableQueryResult res = session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : res) {
                    proxies.add(new IdRef((String)map.get("ecm:uuid")));
                }
            }
            session.removeDocuments(proxies.toArray(new DocumentRef[0]));
            session.save();
        }
    }
}

