/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.io;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.nuxeo.ecm.core.bulk.io.BulkParameters;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BulkCommandJsonReader
extends EntityJsonReader<BulkCommand> {
    public BulkCommandJsonReader() {
        super("bulkCommand");
    }

    protected BulkCommand readEntity(JsonNode jn) {
        Function<String, String> getter = fieldName -> jn.get(fieldName).asText();
        Map<String, Serializable> params = Collections.emptyMap();
        if (jn.has("params")) {
            params = BulkParameters.paramsToMap(jn.get("params"));
        }
        int batchSize = Integer.parseInt(getter.apply("batch"));
        int bucketSize = Integer.parseInt(getter.apply("bucket"));
        return new BulkCommand.Builder(getter.apply("action"), getter.apply("query"), getter.apply("username")).repository(getter.apply("repository")).bucket(bucketSize).batch(batchSize).params(params).build();
    }
}

