/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scroll;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.scroll.Scroll;

@XObject(value="scroll")
@XRegistry(enable=false, compatWarnOnMerge=true)
@XRegistryId(value={"@type", "@name"})
public class ScrollDescriptor {
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected boolean isEnabled = true;
    @XNode(value="@type")
    protected String type;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@default")
    protected boolean isDefault;
    @XNode(value="@class")
    protected Class<? extends Scroll> scrollClass;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> options = new HashMap<String, String>();
    protected Map<String, String> optionsReadOnly;

    public String getId() {
        return this.getType() + ":" + this.getName();
    }

    public Scroll newScrollInstance() {
        try {
            return this.scrollClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Cannot create scroll class of type " + this.scrollClass.getName(), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<String, String> getOptions() {
        if (this.optionsReadOnly == null) {
            this.optionsReadOnly = Collections.unmodifiableMap(this.options);
        }
        return this.optionsReadOnly;
    }
}

