/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.function.ThrowableFunction;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.launcher.config.backingservices.BackingChecker;

public class DBCheck
implements BackingChecker {
    private static final Logger log = LogManager.getLogger(DBCheck.class);
    protected static final List<String> DB_EXCLUDE_CHECK_LIST = Arrays.asList("default", "none");
    protected static final String PARAM_DB_DRIVER = "nuxeo.db.driver";
    protected static final String PARAM_DB_JDBC_URL = "nuxeo.db.jdbc.url";
    protected static final String PARAM_DB_HOST = "nuxeo.db.host";
    protected static final String PARAM_DB_PORT = "nuxeo.db.port";
    protected static final String PARAM_DB_NAME = "nuxeo.db.name";
    protected static final String PARAM_DB_USER = "nuxeo.db.user";
    protected static final String PARAM_DB_PWD = "nuxeo.db.password";

    public boolean accepts(ConfigurationHolder configHolder) {
        return !DB_EXCLUDE_CHECK_LIST.contains(configHolder.getProperty("nuxeo.db.type"));
    }

    public void check(ConfigurationHolder configHolder) throws ConfigurationException {
        try {
            this.checkDatabaseConnection(configHolder);
        }
        catch (DatabaseDriverException e) {
            log.debug((Object)e, (Throwable)e);
            log.error(e.getMessage());
            throw new ConfigurationException("Could not find database driver: " + e.getMessage());
        }
        catch (SQLException e) {
            log.debug((Object)e, (Throwable)e);
            log.error(e.getMessage());
            throw new ConfigurationException("Failed to connect on database: " + e.getMessage());
        }
    }

    public void checkDatabaseConnection(ConfigurationHolder configHolder) throws ConfigurationException, DatabaseDriverException, SQLException {
        String databaseTemplate = configHolder.getIncludedDBTemplateName();
        String dbName = configHolder.getProperty(PARAM_DB_NAME);
        String dbUser = configHolder.getProperty(PARAM_DB_USER);
        String dbPassword = configHolder.getProperty(PARAM_DB_PWD);
        String dbHost = configHolder.getProperty(PARAM_DB_HOST);
        String dbPort = configHolder.getProperty(PARAM_DB_PORT);
        Path databaseTemplateDir = configHolder.getTemplatesPath().resolve(databaseTemplate);
        String classname = configHolder.getProperty(PARAM_DB_DRIVER);
        String connectionUrl = configHolder.getProperty(PARAM_DB_JDBC_URL);
        Driver driver = this.lookupDriver(configHolder, databaseTemplateDir, classname);
        DriverManager.registerDriver(driver);
        Properties ttProps = new Properties();
        ttProps.put(PARAM_DB_HOST, dbHost);
        ttProps.put(PARAM_DB_PORT, dbPort);
        ttProps.put(PARAM_DB_NAME, dbName);
        ttProps.put(PARAM_DB_USER, dbUser);
        ttProps.put(PARAM_DB_PWD, dbPassword);
        TextTemplate tt = new TextTemplate(ttProps);
        String url = tt.processText(connectionUrl);
        Properties conProps = new Properties();
        conProps.put("user", dbUser);
        conProps.put("password", dbPassword);
        log.debug("Testing URL: {} with: {}", (Object)url, (Object)conProps);
        Connection con = driver.connect(url, conProps);
        con.close();
    }

    protected Driver lookupDriver(ConfigurationHolder configHolder, Path databaseTemplateDir, String classname) throws DatabaseDriverException {
        PathMatcher jar = FileSystems.getDefault().getPathMatcher("glob:**.jar");
        URL[] urls = (URL[])Stream.of(databaseTemplateDir.resolve("lib"), configHolder.getHomePath().resolve("lib")).map(Path::toFile).map(File::listFiles).filter(Objects::nonNull).flatMap(Stream::of).map(File::toPath).filter(jar::matches).map(Path::toUri).map(ThrowableFunction.asFunction(URI::toURL)).peek(p -> log.debug("Added file: {}", p)).toArray(URL[]::new);
        URLClassLoader ucl = new URLClassLoader(urls);
        try {
            return (Driver)Class.forName(classname, true, ucl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DatabaseDriverException((Exception)e);
        }
    }
}

