/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidations;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsQueue;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.metrics.MetricsService;

public class UnifiedCachingRowMapper
implements RowMapper {
    private static final Log log = LogFactory.getLog(UnifiedCachingRowMapper.class);
    private static final String ABSENT = "__ABSENT__\u0000\u0000\u0000";
    private static CacheManager cacheManager = null;
    protected static boolean isXA;
    private Cache cache;
    private Model model;
    private RowMapper rowMapper;
    private final VCSInvalidations localInvalidations;
    private final VCSInvalidationsQueue invalidationsQueue;
    private VCSInvalidationsPropagator invalidationsPropagator;
    private static final String CACHE_NAME = "unifiedVCSCache";
    private static final String EHCACHE_FILE_PROP = "ehcacheFilePath";
    private static AtomicInteger rowMapperCount;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected Counter cacheHitCount;
    protected Timer cacheGetTimer;
    protected Counter sorRows;
    protected Timer sorGetTimer;

    public UnifiedCachingRowMapper() {
        this.localInvalidations = new VCSInvalidations();
        this.invalidationsQueue = new VCSInvalidationsQueue("mapper-" + this);
    }

    public synchronized void initialize(String repositoryName, Model model, RowMapper rowMapper, VCSInvalidationsPropagator invalidationsPropagator, Map<String, String> properties) {
        this.model = model;
        this.rowMapper = rowMapper;
        this.invalidationsPropagator = invalidationsPropagator;
        invalidationsPropagator.addQueue(this.invalidationsQueue);
        if (cacheManager == null) {
            if (properties.containsKey(EHCACHE_FILE_PROP)) {
                String value = properties.get(EHCACHE_FILE_PROP);
                log.info((Object)("Creating ehcache manager for VCS, using ehcache file: " + value));
                cacheManager = CacheManager.create((String)value);
            } else {
                log.info((Object)"Creating ehcache manager for VCS, No ehcache file provided");
                cacheManager = CacheManager.create();
            }
            isXA = ((CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(CACHE_NAME)).isXaTransactional();
            MBeanServer mBeanServer = ((ServerLocator)Framework.getService(ServerLocator.class)).lookupServer();
            ManagementService.registerMBeans((CacheManager)cacheManager, (MBeanServer)mBeanServer, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        rowMapperCount.incrementAndGet();
        this.cache = cacheManager.getCache(CACHE_NAME);
        this.setMetrics(repositoryName);
    }

    protected void setMetrics(String repositoryName) {
        this.cacheHitCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "unified", "hit"}).tagged(new String[]{"repository", repositoryName}));
        this.cacheGetTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "unified", "timer"}).tagged(new String[]{"repository", repositoryName}));
        this.sorRows = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "unified", "sor", "rows"}).tagged(new String[]{"repository", repositoryName}));
        this.sorGetTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "unified", "sor", "timer"}).tagged(new String[]{"repository", repositoryName}));
        MetricName gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "unified", "size"});
        SortedMap gauges = this.registry.getGauges();
        if (!gauges.containsKey(gaugeName)) {
            this.registry.register(gaugeName, (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    if (cacheManager != null) {
                        return cacheManager.getCache(UnifiedCachingRowMapper.CACHE_NAME).getSize();
                    }
                    return 0;
                }
            });
        }
    }

    public void close() {
        this.invalidationsPropagator.removeQueue(this.invalidationsQueue);
        rowMapperCount.decrementAndGet();
    }

    @Override
    public Serializable generateNewId() {
        return this.rowMapper.generateNewId();
    }

    protected boolean hasTransaction() {
        Transaction transaction;
        TransactionManagerLookup transactionManagerLookup = this.cache.getTransactionManagerLookup();
        if (transactionManagerLookup == null) {
            return false;
        }
        TransactionManager transactionManager = transactionManagerLookup.getTransactionManager();
        if (transactionManager == null) {
            return false;
        }
        try {
            transaction = transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        return transaction != null;
    }

    protected boolean useEhCache() {
        return !isXA || this.hasTransaction();
    }

    protected void ehCachePut(Element element) {
        if (this.useEhCache()) {
            this.cache.put(element);
        }
    }

    protected Element ehCacheGet(Serializable key) {
        if (this.useEhCache()) {
            return this.cache.get(key);
        }
        return null;
    }

    protected int ehCacheGetSize() {
        if (this.useEhCache()) {
            return this.cache.getSize();
        }
        return 0;
    }

    protected boolean ehCacheRemove(Serializable key) {
        if (this.useEhCache()) {
            return this.cache.remove(key);
        }
        return false;
    }

    protected void ehCacheRemoveAll() {
        if (this.useEhCache()) {
            this.cache.removeAll();
        }
    }

    protected static boolean isAbsent(Row row) {
        return row.tableName == ABSENT;
    }

    protected void cachePut(Row row) {
        if ((row = row.clone()).isCollection() && row.values.length > 0 && row.values[0] instanceof ACLRow) {
            row.values = this.sortACLRows((ACLRow[])row.values);
        }
        Element element = new Element((Serializable)new RowId(row), (Serializable)row);
        this.ehCachePut(element);
    }

    protected ACLRow[] sortACLRows(ACLRow[] acls) {
        ArrayList<ACLRow> list = new ArrayList<ACLRow>(Arrays.asList(acls));
        Collections.sort(list, ACLRow.ACLRowPositionComparator.INSTANCE);
        ACLRow[] res = new ACLRow[acls.length];
        return list.toArray(res);
    }

    protected void cachePutAbsent(RowId rowId) {
        Element element = new Element((Serializable)new RowId(rowId), (Serializable)new Row(ABSENT, (Serializable)null));
        this.ehCachePut(element);
    }

    protected void cachePutAbsentIfNull(RowId rowId, Row row) {
        if (row != null) {
            this.cachePut(row);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    protected void cachePutAbsentIfRowId(RowId rowId) {
        if (rowId instanceof Row) {
            this.cachePut((Row)rowId);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row cacheGet(RowId rowId) {
        Timer.Context context = this.cacheGetTimer.time();
        try {
            Element element = this.ehCacheGet(rowId);
            Row row = null;
            if (element != null) {
                row = (Row)element.getObjectValue();
            }
            if (row != null && !UnifiedCachingRowMapper.isAbsent(row)) {
                row = row.clone();
            }
            if (row != null) {
                this.cacheHitCount.inc();
            }
            Row row2 = row;
            return row2;
        }
        finally {
            context.stop();
        }
    }

    protected void cacheRemove(RowId rowId) {
        this.ehCacheRemove(rowId);
    }

    @Override
    public VCSInvalidations receiveInvalidations() {
        VCSInvalidations remoteInvals = this.rowMapper.receiveInvalidations();
        VCSInvalidations ret = (VCSInvalidations)this.invalidationsQueue.getInvalidations();
        if (remoteInvals != null && !ret.all) {
            if (remoteInvals.modified != null) {
                for (RowId rowId : remoteInvals.modified) {
                    this.cacheRemove(rowId);
                }
            }
            if (remoteInvals.deleted != null) {
                for (RowId rowId : remoteInvals.deleted) {
                    this.cachePutAbsent(rowId);
                }
            }
        }
        if (ret.all) {
            this.clearCache();
        }
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public void sendInvalidations(VCSInvalidations invalidations) {
        if (!this.localInvalidations.isEmpty()) {
            if (invalidations == null) {
                invalidations = new VCSInvalidations();
            }
            invalidations.add(this.localInvalidations);
            this.localInvalidations.clear();
        }
        if (invalidations != null && !invalidations.isEmpty()) {
            this.rowMapper.sendInvalidations(invalidations);
            this.invalidationsPropagator.propagateInvalidations(invalidations, this.invalidationsQueue);
        }
    }

    @Override
    public void clearCache() {
        this.ehCacheRemoveAll();
        this.localInvalidations.clear();
        this.rowMapper.clearCache();
    }

    @Override
    public void rollback() {
        try {
            this.rowMapper.rollback();
        }
        finally {
            this.ehCacheRemoveAll();
            this.localInvalidations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds, boolean cacheOnly) {
        ArrayList<? extends RowId> res = new ArrayList<RowId>(rowIds.size());
        LinkedList<RowId> todo = new LinkedList<RowId>();
        for (RowId rowId : rowIds) {
            Row row = this.cacheGet(rowId);
            if (row == null) {
                if (cacheOnly) {
                    res.add(new RowId(rowId));
                    continue;
                }
                todo.add(rowId);
                continue;
            }
            if (UnifiedCachingRowMapper.isAbsent(row)) {
                res.add(new RowId(rowId));
                continue;
            }
            res.add(row);
        }
        if (!todo.isEmpty()) {
            Timer.Context context = this.sorGetTimer.time();
            try {
                List<? extends RowId> fetched = this.rowMapper.read(todo, cacheOnly);
                for (RowId rowId : fetched) {
                    this.cachePutAbsentIfRowId(rowId);
                }
                res.addAll(fetched);
                this.sorRows.inc((long)fetched.size());
            }
            finally {
                context.stop();
            }
        }
        return res;
    }

    @Override
    public void write(RowMapper.RowBatch batch) {
        for (Row row : batch.creates) {
            this.cachePut(row);
            if ("fulltext".equals(row.tableName)) continue;
            this.localInvalidations.addModified(new RowId(row));
        }
        for (RowMapper.RowUpdate rowu : batch.updates) {
            this.cachePut(rowu.row);
            if ("fulltext".equals(rowu.row.tableName)) continue;
            this.localInvalidations.addModified(new RowId(rowu.row));
        }
        for (RowId rowId : batch.deletes) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            if ("fulltext".equals(rowId.tableName)) continue;
            this.localInvalidations.addDeleted(rowId);
        }
        for (RowId rowId : batch.deletesDependent) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            if ("fulltext".equals(rowId.tableName)) continue;
            this.localInvalidations.addDeleted(rowId);
        }
        this.rowMapper.write(batch);
    }

    @Override
    public Row readSimpleRow(RowId rowId) {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            row = this.rowMapper.readSimpleRow(rowId);
            this.cachePutAbsentIfNull(rowId, row);
            return row;
        }
        if (UnifiedCachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row;
    }

    @Override
    public Map<String, String> getBinaryFulltext(RowId rowId) {
        return this.rowMapper.getBinaryFulltext(rowId);
    }

    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            Serializable[] array = this.rowMapper.readCollectionRowArray(rowId);
            assert (array != null);
            row = new Row(rowId.tableName, rowId.id, array);
            this.cachePut(row);
            return row.values;
        }
        if (UnifiedCachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row.values;
    }

    @Override
    public List<Row> readSelectionRows(SelectionType selType, Serializable selId, Serializable filter, Serializable criterion, boolean limitToOne) {
        List<Row> rows = this.rowMapper.readSelectionRows(selType, selId, filter, criterion, limitToOne);
        for (Row row : rows) {
            this.cachePut(row);
        }
        return rows;
    }

    @Override
    public Set<Serializable> readSelectionsIds(SelectionType selType, List<Serializable> values) {
        return this.rowMapper.readSelectionsIds(selType, values);
    }

    @Override
    public RowMapper.CopyResult copy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow, boolean excludeSpecialChildren, boolean excludeACL) {
        RowMapper.CopyResult result = this.rowMapper.copy(source, destParentId, destName, overwriteRow, excludeSpecialChildren, excludeACL);
        VCSInvalidations invalidations = result.invalidations;
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
                this.localInvalidations.addModified(new RowId(rowId));
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        return result;
    }

    @Override
    public List<RowMapper.NodeInfo> getDescendantsInfo(Serializable rootId) {
        return this.rowMapper.getDescendantsInfo(rootId);
    }

    @Override
    public void remove(Serializable rootId, List<RowMapper.NodeInfo> nodeInfos) {
        this.rowMapper.remove(rootId, nodeInfos);
        for (RowMapper.NodeInfo info : nodeInfos) {
            for (String fragmentName : this.model.getTypeFragments(new RowMapper.IdWithTypes(info))) {
                RowId rowId = new RowId(fragmentName, info.id);
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        this.cachePutAbsent(new RowId("hierarchy", rootId));
    }

    @Override
    public long getCacheSize() {
        return 0L;
    }

    static {
        rowMapperCount = new AtomicInteger();
    }
}

