/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;

@XObject(value="directory")
@XRegistry
public class MultiDirectoryDescriptor
extends BaseDirectoryDescriptor {
    @XNode(value="querySizeLimit")
    public Integer querySizeLimit;
    @XNodeList(value="source", type=SourceDescriptor[].class, componentType=SourceDescriptor.class)
    protected SourceDescriptor[] sources;

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof MultiDirectoryDescriptor) {
            this.merge((MultiDirectoryDescriptor)other);
        }
    }

    protected void merge(MultiDirectoryDescriptor other) {
        if (other.querySizeLimit != null) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.sources != null) {
            if (this.sources == null) {
                this.sources = other.sources;
            } else {
                SourceDescriptor[] s = new SourceDescriptor[this.sources.length + other.sources.length];
                System.arraycopy(this.sources, 0, s, 0, this.sources.length);
                System.arraycopy(other.sources, 0, s, this.sources.length, other.sources.length);
                this.sources = s;
            }
        }
    }

    public MultiDirectoryDescriptor clone() {
        MultiDirectoryDescriptor clone = (MultiDirectoryDescriptor)super.clone();
        if (this.sources != null) {
            clone.sources = new SourceDescriptor[this.sources.length];
            for (int i = 0; i < this.sources.length; ++i) {
                clone.sources[i] = this.sources[i].clone();
            }
        }
        return clone;
    }

    public Directory newDirectory() {
        return new MultiDirectory(this);
    }
}

