/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.IdentityQueryTransformer;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.directory.multi.MultiDirectorySession;

public class MultiDirectoryExpressionEvaluator {
    protected final List<MultiDirectorySession.SubDirectoryInfo> dirInfos;
    protected final String idField;
    protected final String dirName;

    public MultiDirectoryExpressionEvaluator(MultiDirectorySession.SourceInfo sourceInfo, String idField, String dirName) {
        this.dirInfos = sourceInfo.subDirectoryInfos;
        this.idField = idField;
        this.dirName = dirName;
    }

    public Set<String> eval(Expression expr) {
        return this.evaluate(this.evalExpression(expr));
    }

    protected Result evalExpression(Expression expr) {
        Operator op = expr.operator;
        if (expr instanceof MultiExpression) {
            return this.evalMultiExpression((MultiExpression)expr);
        }
        if (op == Operator.AND || op == Operator.OR) {
            return this.evalAndOr(expr);
        }
        return this.evalSimpleExpression(expr);
    }

    protected Result evalSimpleExpression(Expression expr) {
        Result left = this.evalOperand(expr.lvalue);
        Result right = this.evalOperand(expr.rvalue);
        if (left instanceof OperandResult && right instanceof OperandResult) {
            OperandResult lop = (OperandResult)left;
            OperandResult rop = (OperandResult)right;
            if (lop.dir == null || rop.dir == null || lop.dir.equals(rop.dir)) {
                String dir = lop.dir == null ? rop.dir : lop.dir;
                return new OperandResult((Operand)expr, lop.hasId || rop.hasId, dir);
            }
        }
        throw new QueryParseException("Invalid expression for multidirectory: " + expr);
    }

    protected Result evalOperand(Operand op) {
        if (op instanceof Expression) {
            return this.evalExpression((Expression)op);
        }
        if (op instanceof Reference) {
            return this.evalReference((Reference)op);
        }
        return new OperandResult(op, false, null);
    }

    protected Result evalReference(Reference ref) {
        String name = ref.name;
        if (name.equals(this.idField)) {
            return new OperandResult((Operand)ref, true, null);
        }
        for (MultiDirectorySession.SubDirectoryInfo dirInfo : this.dirInfos) {
            if (!dirInfo.fromSource.containsKey(name)) continue;
            return new OperandResult((Operand)ref, false, dirInfo.dirName);
        }
        throw new QueryParseException("No column: " + name + " for directory: " + this.dirName);
    }

    protected Result evalAndOr(Expression expr) {
        List<Predicate> predicates = Arrays.asList((Predicate)expr.lvalue, (Predicate)expr.rvalue);
        return this.evalMultiExpression(new MultiExpression(expr.operator, predicates));
    }

    protected Result evalMultiExpression(MultiExpression expr) {
        boolean and = expr.operator == Operator.AND;
        List predicates = expr.predicates;
        Iterator it = predicates.iterator();
        if (!it.hasNext()) {
            return new OperandResult((Operand)expr, false, null);
        }
        Result previous = this.evalExpression((Expression)it.next());
        while (it.hasNext()) {
            if (and && previous instanceof IdsResult && ((IdsResult)previous).ids.isEmpty()) {
                return previous;
            }
            Result next = this.evalExpression((Expression)it.next());
            if (previous instanceof OperandResult && next instanceof OperandResult) {
                OperandResult prv = (OperandResult)previous;
                OperandResult nxt = (OperandResult)next;
                if (prv.dir == null || nxt.dir == null || prv.dir.equals(nxt.dir)) {
                    String dir = prv.dir == null ? nxt.dir : prv.dir;
                    previous = new OperandResult((Operand)expr, prv.hasId || nxt.hasId, dir);
                    continue;
                }
            }
            Set<String> previousIds = this.evaluate(previous);
            if (and && previousIds.isEmpty()) {
                return new IdsResult(previousIds);
            }
            Set<String> nextIds = this.evaluate(next);
            Set<String> ids = and ? MultiDirectoryExpressionEvaluator.intersection(previousIds, nextIds) : MultiDirectoryExpressionEvaluator.union(previousIds, nextIds);
            previous = new IdsResult(ids);
        }
        return previous;
    }

    protected Set<String> evaluate(Result result) {
        if (result instanceof IdsResult) {
            return ((IdsResult)result).ids;
        }
        return this.evaluate((OperandResult)result);
    }

    protected Set<String> evaluate(OperandResult opr) {
        MultiDirectorySession.SubDirectoryInfo subDirInfo = null;
        for (MultiDirectorySession.SubDirectoryInfo dirInfo : this.dirInfos) {
            if (opr.dir != null) {
                if (!opr.dir.equals(dirInfo.dirName)) continue;
                subDirInfo = dirInfo;
                break;
            }
            if (dirInfo.isOptional) continue;
            subDirInfo = dirInfo;
            break;
        }
        if (subDirInfo == null) {
            throw new QueryParseException("Configuration error: no non-optional subdirectory for multidirectory: " + this.dirName);
        }
        Predicate predicate = new ReferenceRenamer(subDirInfo.fromSource).transform((Predicate)opr.operand);
        QueryBuilder queryBuilder = new QueryBuilder();
        if (predicate instanceof MultiExpression) {
            queryBuilder.filter((MultiExpression)predicate);
        } else {
            queryBuilder.predicate(predicate);
        }
        return new HashSet<String>(subDirInfo.getSession().queryIds(queryBuilder));
    }

    protected static Set<String> union(Set<String> a, Set<String> b) {
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(a);
        if (set.addAll(b)) {
            return set;
        }
        return a;
    }

    protected static Set<String> intersection(Set<String> a, Set<String> b) {
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(a);
        if (set.retainAll(b)) {
            return set;
        }
        return a;
    }

    public static class ReferenceRenamer
    extends IdentityQueryTransformer {
        protected final Map<String, String> map;

        public ReferenceRenamer(Map<String, String> map) {
            this.map = map;
        }

        public Reference transform(Reference node) {
            String name = node.name;
            String newName = this.map.getOrDefault(name, name);
            if (newName.equals(name)) {
                return node;
            }
            return new Reference(newName, node.cast, node.esHint);
        }
    }

    public static class OperandResult
    implements Result {
        public final Operand operand;
        public final boolean hasId;
        public final String dir;

        public OperandResult(Operand operand, boolean hasId, String dir) {
            this.operand = operand;
            this.hasId = hasId;
            this.dir = dir;
        }
    }

    public static class IdsResult
    implements Result {
        public final Set<String> ids;

        public IdsResult(Set<String> ids) {
            this.ids = ids;
        }
    }

    public static interface Result {
    }
}

