/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.impl.BridgeCommentManager;
import org.nuxeo.ecm.platform.comment.impl.CommentManagerImpl;
import org.nuxeo.ecm.platform.comment.impl.PropertyCommentManager;
import org.nuxeo.ecm.platform.comment.impl.TreeCommentManager;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class CommentService
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(CommentService.class);
    public static final String ID = "org.nuxeo.ecm.platform.comment.service.CommentService";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.comment.service.CommentService");
    protected static final String CONFIG_XP = "config";
    protected volatile CommentManager commentManager;

    @Deprecated(since="11.1")
    public CommentManager getCommentManager() {
        log.debug("getCommentManager");
        if (this.commentManager == null) {
            this.commentManager = new CommentManagerImpl(this.getConfig());
        }
        return this.commentManager;
    }

    public CommentServiceConfig getConfig() {
        return (CommentServiceConfig)this.getRegistryContribution(CONFIG_XP).orElseThrow(() -> new RuntimeServiceException("Missing configuration for CommentService"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommentService.class) {
            return adapter.cast((Object)this);
        }
        if (this.commentManager == null) {
            CommentService commentService = this;
            synchronized (commentService) {
                if (this.commentManager == null) {
                    this.commentManager = this.recomputeCommentManager();
                }
            }
        }
        return (T)this.commentManager;
    }

    protected CommentManager recomputeCommentManager() {
        MigrationService migrationService = (MigrationService)Framework.getService(MigrationService.class);
        MigrationService.MigrationStatus status = migrationService.getStatus("comment-storage");
        if (status == null) {
            throw new IllegalStateException("Unknown migration status for: comment-storage");
        }
        if (status.isRunning()) {
            String step = status.getStep();
            if ("relation-to-property".equals(step)) {
                return new BridgeCommentManager(new CommentManagerImpl(this.getConfig()), new PropertyCommentManager());
            }
            if ("property-to-secured".equals(step)) {
                return new BridgeCommentManager(new PropertyCommentManager(), new TreeCommentManager());
            }
            throw new IllegalStateException("Unknown migration step: " + step);
        }
        String state = status.getState();
        if ("relation".equals(state)) {
            return new CommentManagerImpl(this.getConfig());
        }
        if ("property".equals(state)) {
            return new PropertyCommentManager();
        }
        if ("secured".equals(state)) {
            return new TreeCommentManager();
        }
        throw new IllegalStateException("Unknown migration state: " + state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCommentManagerImplementation() {
        CommentService commentService = this;
        synchronized (commentService) {
            this.commentManager = this.recomputeCommentManager();
        }
    }
}

