/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntryAdaptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.ldap.DefaultLdapExceptionProcessor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPTreeReference;
import org.nuxeo.ecm.directory.ldap.LdapExceptionProcessor;
import org.nuxeo.ecm.directory.ldap.LdapScope;

@XObject(value="directory")
@XRegistry
public class LDAPDirectoryDescriptor
extends BaseDirectoryDescriptor {
    public static final Log log = LogFactory.getLog(LDAPDirectoryDescriptor.class);
    public static final int DEFAULT_SEARCH_SCOPE = 1;
    public static final String DEFAULT_SEARCH_CLASSES_FILTER = "(objectClass=*)";
    public static final String DEFAULT_EMPTY_REF_MARKER = "cn=emptyRef";
    public static final String DEFAULT_MISSING_ID_FIELD_CASE = "unchanged";
    public static final String DEFAULT_ID_CASE = "unchanged";
    public static final int DEFAULT_QUERY_SIZE_LIMIT = 200;
    public static final int DEFAULT_QUERY_TIME_LIMIT = 0;
    public static final boolean DEFAULT_FOLLOW_REFERRALS = true;
    @XNode(value="server")
    public String serverName;
    @XNode(value="searchBaseDn")
    public String searchBaseDn;
    @XNodeMap(value="fieldMapping", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> fieldMapping = new HashMap<String, String>();
    public String[] searchClasses;
    public String searchClassesFilter;
    public String searchFilter;
    public Integer searchScope;
    @XNode(value="creationBaseDn")
    public String creationBaseDn;
    @XNodeList(value="creationClass", componentType=String.class, type=String[].class)
    public String[] creationClasses;
    @XNode(value="rdnAttribute")
    public String rdnAttribute;
    @XNodeList(value="references/ldapReference", type=LDAPReference[].class, componentType=LDAPReference.class)
    private LDAPReference[] ldapReferences;
    @XNodeList(value="references/ldapTreeReference", type=LDAPTreeReference[].class, componentType=LDAPTreeReference.class)
    private LDAPTreeReference[] ldapTreeReferences;
    @XNode(value="emptyRefMarker")
    public String emptyRefMarker;
    @XNode(value="missingIdFieldCase")
    public String missingIdFieldCase;
    @XNode(value="idCase")
    public String idCase = "unchanged";
    @XNode(value="querySizeLimit")
    private Integer querySizeLimit;
    @XNode(value="queryTimeLimit")
    private Integer queryTimeLimit;
    @XNode(value="followReferrals")
    protected Boolean followReferrals;
    protected EntryAdaptor entryAdaptor;
    @XNode(value="ldapExceptionHandler")
    protected Class<? extends LdapExceptionProcessor> exceptionProcessorClass;
    protected LdapExceptionProcessor exceptionProcessor;

    public String getMissingIdFieldCase() {
        return this.missingIdFieldCase == null ? "unchanged" : this.missingIdFieldCase;
    }

    public boolean getFollowReferrals() {
        return this.followReferrals == null ? true : this.followReferrals;
    }

    @XNode(value="entryAdaptor")
    public void setEntryAdaptor(EntryAdaptorDescriptor adaptorDescriptor) throws ReflectiveOperationException {
        this.entryAdaptor = adaptorDescriptor.adaptorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Map.Entry<String, String> paramEntry : adaptorDescriptor.parameters.entrySet()) {
            this.entryAdaptor.setParameter(paramEntry.getKey(), paramEntry.getValue());
        }
    }

    public String getRdnAttribute() {
        return this.rdnAttribute;
    }

    public String getCreationBaseDn() {
        return this.creationBaseDn;
    }

    public String[] getCreationClasses() {
        return this.creationClasses;
    }

    public String getIdCase() {
        return this.idCase;
    }

    public String getSearchBaseDn() {
        return this.searchBaseDn;
    }

    @XNodeList(value="searchClass", componentType=String.class, type=String[].class)
    public void setSearchClasses(String[] searchClasses) {
        this.searchClasses = searchClasses;
        if (searchClasses == null) {
            this.searchClassesFilter = DEFAULT_SEARCH_CLASSES_FILTER;
            return;
        }
        ArrayList<CallSite> searchClassFilters = new ArrayList<CallSite>();
        for (String searchClass : searchClasses) {
            searchClassFilters.add((CallSite)((Object)("(objectClass=" + searchClass + ")")));
        }
        this.searchClassesFilter = StringUtils.join((Object[])searchClassFilters.toArray());
        if (searchClasses.length > 1) {
            this.searchClassesFilter = "(|" + this.searchClassesFilter + ")";
        }
    }

    public String[] getSearchClasses() {
        return this.searchClasses;
    }

    @XNode(value="searchFilter")
    public void setSearchFilter(String searchFilter) {
        if (searchFilter == null || ((String)searchFilter).equals(DEFAULT_SEARCH_CLASSES_FILTER)) {
            this.searchFilter = null;
            return;
        }
        if (!((String)searchFilter).startsWith("(") && !((String)searchFilter).endsWith(")")) {
            searchFilter = "(" + (String)searchFilter + ")";
        }
        this.searchFilter = searchFilter;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    @XNode(value="searchScope")
    public void setSearchScope(String searchScope) {
        if (searchScope == null) {
            this.searchScope = null;
            return;
        }
        Integer scope = LdapScope.getIntegerScope(searchScope);
        if (scope == null) {
            throw new DirectoryException("Invalid search scope: " + searchScope + ". Valid options: object, onelevel, subtree");
        }
        this.searchScope = scope;
    }

    public int getSearchScope() {
        return this.searchScope == null ? 1 : this.searchScope;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getAggregatedSearchFilter() {
        if (this.searchFilter == null) {
            return this.searchClassesFilter;
        }
        return "(&" + this.searchClassesFilter + this.searchFilter + ")";
    }

    public Map<String, String> getFieldMapping() {
        return this.fieldMapping;
    }

    public void setFieldMapping(Map<String, String> fieldMapping) {
        this.fieldMapping = fieldMapping;
    }

    public Reference[] getLdapReferences() {
        ArrayList<AbstractReference> refs = new ArrayList<AbstractReference>();
        if (this.ldapReferences != null) {
            refs.addAll(Arrays.asList(this.ldapReferences));
        }
        if (this.ldapTreeReferences != null) {
            refs.addAll(Arrays.asList(this.ldapTreeReferences));
        }
        return refs.toArray(new Reference[0]);
    }

    public String getEmptyRefMarker() {
        return this.emptyRefMarker == null ? DEFAULT_EMPTY_REF_MARKER : this.emptyRefMarker;
    }

    public void setEmptyRefMarker(String emptyRefMarker) {
        this.emptyRefMarker = emptyRefMarker;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit == null ? 200 : this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public void setQueryTimeLimit(int queryTimeLimit) {
        this.queryTimeLimit = queryTimeLimit;
    }

    public int getQueryTimeLimit() {
        return this.queryTimeLimit == null ? 0 : this.queryTimeLimit;
    }

    public EntryAdaptor getEntryAdaptor() {
        return this.entryAdaptor;
    }

    public LdapExceptionProcessor getExceptionProcessor() {
        if (this.exceptionProcessor == null) {
            if (this.exceptionProcessorClass == null) {
                this.exceptionProcessor = new DefaultLdapExceptionProcessor();
            } else {
                try {
                    this.exceptionProcessor = this.exceptionProcessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)"Unable to instanciate custom Exception handler", (Throwable)e);
                    this.exceptionProcessor = new DefaultLdapExceptionProcessor();
                }
            }
        }
        return this.exceptionProcessor;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof LDAPDirectoryDescriptor) {
            this.merge((LDAPDirectoryDescriptor)other);
        }
    }

    protected void merge(LDAPDirectoryDescriptor other) {
        if (other.serverName != null) {
            this.serverName = other.serverName;
        }
        if (other.searchBaseDn != null) {
            this.searchBaseDn = other.searchBaseDn;
        }
        if (other.fieldMapping != null) {
            this.fieldMapping.putAll(other.fieldMapping);
        }
        if (other.searchClasses != null && other.searchClasses.length > 0) {
            this.searchClasses = (String[])other.searchClasses.clone();
        }
        if (other.searchClassesFilter != null) {
            this.searchClassesFilter = other.searchClassesFilter;
        }
        if (other.searchFilter != null) {
            this.searchFilter = other.searchFilter;
        }
        if (other.searchScope != null) {
            this.searchScope = other.searchScope;
        }
        if (other.creationBaseDn != null) {
            this.creationBaseDn = other.creationBaseDn;
        }
        if (other.creationClasses != null && other.creationClasses.length > 0) {
            this.creationClasses = (String[])other.creationClasses.clone();
        }
        if (other.rdnAttribute != null) {
            this.rdnAttribute = other.rdnAttribute;
        }
        if (other.ldapReferences != null && other.ldapReferences.length > 0) {
            this.ldapReferences = other.ldapReferences;
        }
        if (other.ldapTreeReferences != null && other.ldapTreeReferences.length > 0) {
            this.ldapTreeReferences = other.ldapTreeReferences;
        }
        if (other.emptyRefMarker != null) {
            this.emptyRefMarker = other.emptyRefMarker;
        }
        if (other.missingIdFieldCase != null) {
            this.missingIdFieldCase = other.missingIdFieldCase;
        }
        if (other.idCase != null) {
            this.idCase = other.idCase;
        }
        if (other.querySizeLimit != null) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.queryTimeLimit != null) {
            this.queryTimeLimit = other.queryTimeLimit;
        }
        if (other.followReferrals != null) {
            this.followReferrals = other.followReferrals;
        }
        if (other.entryAdaptor != null) {
            this.entryAdaptor = other.entryAdaptor;
        }
        if (other.exceptionProcessorClass != null) {
            this.exceptionProcessorClass = other.exceptionProcessorClass;
            this.exceptionProcessor = other.exceptionProcessor;
        }
    }

    public LDAPDirectoryDescriptor clone() {
        int i;
        LDAPDirectoryDescriptor clone = (LDAPDirectoryDescriptor)super.clone();
        if (this.fieldMapping != null) {
            clone.fieldMapping = new HashMap<String, String>(this.fieldMapping);
        }
        if (this.searchClasses != null) {
            clone.searchClasses = (String[])this.searchClasses.clone();
        }
        if (this.creationClasses != null) {
            this.creationClasses = (String[])this.creationClasses.clone();
        }
        if (this.ldapReferences != null) {
            clone.ldapReferences = new LDAPReference[this.ldapReferences.length];
            for (i = 0; i < this.ldapReferences.length; ++i) {
                clone.ldapReferences[i] = this.ldapReferences[i].clone();
            }
        }
        if (this.ldapTreeReferences != null) {
            clone.ldapTreeReferences = new LDAPTreeReference[this.ldapTreeReferences.length];
            for (i = 0; i < this.ldapTreeReferences.length; ++i) {
                clone.ldapTreeReferences[i] = this.ldapTreeReferences[i].clone();
            }
        }
        return clone;
    }

    public LDAPDirectory newDirectory() {
        return new LDAPDirectory(this);
    }

    @XObject(value="entryAdaptor")
    public static class EntryAdaptorDescriptor {
        @XNode(value="@class")
        public Class<? extends EntryAdaptor> adaptorClass;
        @XNodeMap(value="parameter", key="@name", type=HashMap.class, componentType=String.class)
        public Map<String, String> parameters;
    }
}

