/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xerces.dom.DocumentImpl;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.web.resources.core.ResourceBundleDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.styling.service.descriptors.PageDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PageRegistry
extends MapRegistry {
    protected static final String GLOBAL_CONFIG_NAME = "*";
    protected PageDescriptor globalPage;
    protected Map<String, PageDescriptor> mergedPages;
    protected static XAnnotatedObject xBundle;

    public void initialize() {
        super.initialize();
        this.mergedPages = Collections.synchronizedMap(new LinkedHashMap());
        this.globalPage = null;
        if (!this.disabled.contains(GLOBAL_CONFIG_NAME)) {
            this.globalPage = (PageDescriptor)this.contributions.get(GLOBAL_CONFIG_NAME);
        }
        if (this.globalPage == null) {
            this.mergedPages.putAll(super.getContributions());
        } else {
            super.getContributions().forEach((k, v) -> {
                if (GLOBAL_CONFIG_NAME.equals(k)) {
                    this.mergedPages.put((String)k, (PageDescriptor)v);
                } else {
                    this.mergedPages.put((String)k, this.mergePage((PageDescriptor)v, this.globalPage));
                }
            });
        }
    }

    public <T> Map<String, T> getContributions() {
        this.checkInitialized();
        return Collections.unmodifiableMap(this.mergedPages);
    }

    public <T> List<T> getContributionValues() {
        this.checkInitialized();
        return new ArrayList<PageDescriptor>(this.mergedPages.values());
    }

    public <T> Optional<T> getContribution(String id) {
        this.checkInitialized();
        if (GLOBAL_CONFIG_NAME.contentEquals(id)) {
            return Optional.ofNullable(this.globalPage);
        }
        if (this.disabled.contains(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mergedPages.get(id));
    }

    public Registry getTargetRegistry() {
        return (Registry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry("org.nuxeo.ecm.platform.WebResources", "bundles").orElseThrow(() -> new IllegalArgumentException("Unknown target registry"));
    }

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        PageDescriptor page = (PageDescriptor)super.doRegister(ctx, xObject, element, extensionId);
        if (page != null) {
            DocumentImpl xmlDoc = new DocumentImpl();
            Element root = xmlDoc.createElement("bundle");
            root.setAttribute("name", page.getComputedResourceBundleName());
            String doMerge = "false";
            XAnnotatedMember merge = xObject.getMerge();
            if (merge != null && Boolean.TRUE.equals(merge.getValue(ctx, element))) {
                doMerge = "true";
            }
            root.setAttribute("merge", doMerge);
            if (page.hasResources()) {
                Element resources = xmlDoc.createElement("resources");
                root.appendChild(resources);
                page.getResources().forEach(arg_0 -> PageRegistry.lambda$doRegister$2((Document)xmlDoc, resources, arg_0));
            }
            this.getTargetRegistry().register(ctx, xBundle, root, extensionId);
        }
        return (T)page;
    }

    protected PageDescriptor mergePage(PageDescriptor page, PageDescriptor globalPage) {
        if (globalPage == null) {
            return page;
        }
        String charset = page.getCharset() != null ? page.getCharset() : globalPage.getCharset();
        String defaultFlavor = page.getDefaultFlavor() != null ? page.getDefaultFlavor() : globalPage.getDefaultFlavor();
        List<String> flavors = Stream.of(page.getFlavors(), globalPage.getFlavors()).flatMap(Collection::stream).collect(Collectors.toList());
        List<String> resources = Stream.of(page.getResources(), globalPage.getResources()).flatMap(Collection::stream).collect(Collectors.toList());
        List<String> bundles = Stream.of(page.getDeclaredResourceBundles(), globalPage.getDeclaredResourceBundles()).flatMap(Collection::stream).collect(Collectors.toList());
        return new PageDescriptor(page.getName(), charset, defaultFlavor, flavors, resources, bundles);
    }

    public PageDescriptor getPage(String id) {
        return this.getContribution(id).orElse(null);
    }

    public List<PageDescriptor> getPages() {
        return this.getContributionValues();
    }

    public List<String> getPageNames() {
        return new ArrayList<String>(this.getContributions().keySet());
    }

    public PageDescriptor getConfigurationApplyingToAll() {
        return this.getPage(GLOBAL_CONFIG_NAME);
    }

    private static /* synthetic */ void lambda$doRegister$2(Document xmlDoc, Element resources, String r) {
        Element resource = xmlDoc.createElement("resource");
        resource.appendChild(xmlDoc.createTextNode(r));
        resources.appendChild(resource);
    }

    static {
        XMap fxmap = new XMap();
        fxmap.register(ResourceBundleDescriptor.class);
        xBundle = fxmap.getObject(ResourceBundleDescriptor.class);
    }
}

