/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.AliasMapRegistry;
import org.w3c.dom.Element;

public abstract class AbstractCategoryMapRegistry
implements Registry {
    private static final Logger log = LogManager.getLogger(AbstractCategoryMapRegistry.class);
    protected Map<String, MapRegistry> registries = new ConcurrentHashMap<String, MapRegistry>();

    protected abstract List<String> getCategories(Context var1, XAnnotatedObject var2, Element var3);

    protected <T> List<String> getContributionAliases(T contribution) {
        return Collections.emptyList();
    }

    protected <T> Object getConvertedContribution(T contribution) {
        return contribution;
    }

    public List<String> getCategories() {
        return new ArrayList<String>(this.registries.keySet());
    }

    public <T> Map<String, T> getContributions(String category) {
        MapRegistry registry = this.registries.get(category);
        if (registry != null) {
            return registry.getContributions();
        }
        return Collections.emptyMap();
    }

    public <T> List<T> getContributionValues(String category) {
        MapRegistry registry = this.registries.get(category);
        if (registry != null) {
            return registry.getContributionValues();
        }
        return Collections.emptyList();
    }

    public <T> T getContribution(String category, String id) {
        MapRegistry registry = this.registries.get(category);
        if (registry == null) {
            return null;
        }
        return registry.getContribution(id).orElse(null);
    }

    public void initialize() {
        this.registries.values().forEach(MapRegistry::initialize);
    }

    public void tag(String id) {
        this.registries.values().forEach(r -> r.tag(id));
    }

    public boolean isTagged(String id) {
        return this.registries.values().stream().anyMatch(r -> r.isTagged(id));
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        List<String> categories = this.getCategories(ctx, xObject, element);
        if (categories.isEmpty()) {
            log.error("Cannot register contribution '{}': no category found", xObject.newInstance(ctx, element));
            return;
        }
        categories.forEach(cat -> this.registries.computeIfAbsent((String)cat, k -> new AliasMapRegistry(){

            @Override
            protected <T> List<String> getAliases(T contribution) {
                return AbstractCategoryMapRegistry.this.getContributionAliases(contribution);
            }

            @Override
            protected <T> Object getStoredContribution(T contribution) {
                return AbstractCategoryMapRegistry.this.getConvertedContribution(contribution);
            }
        }).register(ctx, xObject, element, tag));
    }

    public void unregister(String tag) {
        this.registries.values().stream().filter(r -> r.isTagged(tag)).forEach(r -> r.unregister(tag));
    }
}

