/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.RenderingInfo;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutRowDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.RenderingInfoDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.RenderingInfosDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;

@XObject(value="layout")
@XRegistry(merge=false)
public class LayoutDescriptor {
    @XNode(value="@name")
    @XRegistryId
    String name;
    @XNode(value="@type")
    String type;
    @XNode(value="@typeCategory")
    String typeCategory;
    @XNodeMap(value="templates/template", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> templates = new HashMap<String, String>();
    @XNodeList(value="rows/row", type=LayoutRowDescriptor[].class, componentType=LayoutRowDescriptor.class)
    LayoutRowDescriptor[] rows = new LayoutRowDescriptor[0];
    @XNodeList(value="columns/column", type=LayoutRowDescriptor[].class, componentType=LayoutRowDescriptor.class)
    LayoutRowDescriptor[] rowsAsColumns = new LayoutRowDescriptor[0];
    @XNodeMap(value="widget", key="@name", type=HashMap.class, componentType=WidgetDescriptor.class)
    Map<String, WidgetDescriptor> widgets = new HashMap<String, WidgetDescriptor>();
    @XNodeMap(value="properties", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> properties = new HashMap<String, PropertiesDescriptor>();
    @XNodeMap(value="renderingInfos", key="@mode", type=HashMap.class, componentType=RenderingInfosDescriptor.class)
    Map<String, RenderingInfosDescriptor> renderingInfos = new HashMap<String, RenderingInfosDescriptor>();
    @XNode(value="@category")
    protected String category;
    @XNodeList(value="categories/category", type=String[].class, componentType=String.class)
    String[] categories = new String[0];
    @XNodeList(value="aliases/alias", type=ArrayList.class, componentType=String.class)
    List<String> aliases;
    Integer columns;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeCategory() {
        return this.typeCategory;
    }

    public String getTemplate(String mode) {
        String template = this.templates.get(mode);
        if (template == null) {
            template = this.templates.get("any");
        }
        return template;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    protected LayoutRowDefinition[] getDefinitions(LayoutRowDescriptor[] rows) {
        LayoutRowDefinition[] crows = null;
        if (rows != null) {
            crows = new LayoutRowDefinition[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                crows[i] = rows[i].getLayoutRowDefinition();
            }
        }
        return crows;
    }

    public LayoutRowDefinition[] getRows() {
        if (this.rowsAsColumns != null && this.rowsAsColumns.length > 0) {
            return this.getDefinitions(this.rowsAsColumns);
        }
        return this.getDefinitions(this.rows);
    }

    public int getColumns() {
        if (this.columns == null) {
            LayoutRowDefinition[] rows;
            this.columns = 0;
            for (LayoutRowDefinition def : rows = this.getRows()) {
                int current = def.getWidgetReferences().length;
                if (current <= this.columns) continue;
                this.columns = current;
            }
        }
        return this.columns;
    }

    protected WidgetDefinition getWidgetDefinition(WidgetDescriptor desc) {
        if (desc == null) {
            return null;
        }
        return desc.getWidgetDefinition();
    }

    public WidgetDefinition getWidgetDefinition(String name) {
        return this.getWidgetDefinition(this.widgets.get(name));
    }

    public Map<String, Serializable> getProperties(String layoutMode) {
        return WidgetDescriptor.getProperties(this.properties, layoutMode);
    }

    public Map<String, Map<String, Serializable>> getProperties() {
        return WidgetDescriptor.getProperties(this.properties);
    }

    public String[] getCategories() {
        HashSet<String> cats = new HashSet<String>();
        if (this.category != null) {
            cats.add(this.category);
        }
        cats.addAll(Arrays.asList(this.categories));
        return (String[])cats.toArray(String[]::new);
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public LayoutDefinition getLayoutDefinition() {
        HashMap<String, String> ctemplates = null;
        if (this.templates != null) {
            ctemplates = new HashMap<String, String>();
            ctemplates.putAll(this.templates);
        }
        LayoutRowDefinition[] crows = this.getRows();
        LinkedHashMap<String, WidgetDefinition> cwidgets = null;
        if (this.widgets != null) {
            cwidgets = new LinkedHashMap<String, WidgetDefinition>();
            for (Map.Entry<String, WidgetDescriptor> entry : this.widgets.entrySet()) {
                WidgetDescriptor widgetDescriptor = entry.getValue();
                cwidgets.put(entry.getKey(), this.getWidgetDefinition(widgetDescriptor));
            }
        }
        HashMap crenderingInfos = null;
        if (this.renderingInfos != null) {
            crenderingInfos = new HashMap();
            for (Map.Entry<String, RenderingInfosDescriptor> entry : this.renderingInfos.entrySet()) {
                RenderingInfosDescriptor infos = entry.getValue();
                ArrayList<RenderingInfo> clonedInfos = null;
                if (infos != null) {
                    clonedInfos = new ArrayList<RenderingInfo>();
                    for (RenderingInfoDescriptor info : infos.getRenderingInfos()) {
                        clonedInfos.add(info.getRenderingInfo());
                    }
                }
                crenderingInfos.put(entry.getKey(), clonedInfos);
            }
        }
        LayoutDefinitionImpl layoutDefinitionImpl = new LayoutDefinitionImpl(this.name, this.getProperties(), ctemplates, crows, cwidgets);
        layoutDefinitionImpl.setRenderingInfos(crenderingInfos);
        layoutDefinitionImpl.setType(this.getType());
        layoutDefinitionImpl.setTypeCategory(this.getTypeCategory());
        if (this.aliases != null) {
            layoutDefinitionImpl.setAliases(new ArrayList<String>(this.aliases));
        }
        return layoutDefinitionImpl;
    }
}

