/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.process;

import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.nuxeo.launcher.process.MacProcessManager;
import org.nuxeo.launcher.process.SolarisProcessManager;
import org.nuxeo.launcher.process.UnixProcessManager;
import org.nuxeo.launcher.process.WindowsProcessManager;

public class ProcessManager {
    protected final Pattern processPattern;

    protected ProcessManager(Pattern processPattern) {
        this.processPattern = processPattern;
    }

    public Optional<Long> findPid() throws IOException {
        try {
            return ProcessHandle.allProcesses().filter(ph -> this.processPattern.matcher(ProcessManager.getCommandLine(ph)).matches()).map(ProcessHandle::pid).findFirst();
        }
        catch (UnsupportedOperationException e) {
            throw new IOException("Your system doesn't support looking up of process", e);
        }
    }

    protected static String getCommandLine(ProcessHandle ph) {
        try {
            return ph.info().commandLine().orElse("");
        }
        catch (RuntimeException e) {
            if ("Input/output error".equals(e.getMessage())) {
                return "";
            }
            throw e;
        }
    }

    public void kill(ProcessHandle processHandle) throws IOException {
        processHandle.destroy();
    }

    public static ProcessManager of(String commandRegex) {
        ProcessManager manager;
        Pattern commandPattern = Pattern.compile(commandRegex);
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_AIX) {
            manager = new UnixProcessManager(commandPattern);
        } else if (SystemUtils.IS_OS_MAC) {
            manager = new MacProcessManager(commandPattern);
        } else if (SystemUtils.IS_OS_SUN_OS) {
            String solarisVersion = SolarisProcessManager.getSolarisVersion();
            manager = new SolarisProcessManager(commandPattern, solarisVersion);
        } else {
            manager = SystemUtils.IS_OS_WINDOWS ? (WindowsProcessManager.isUsable() ? new WindowsProcessManager(commandPattern) : new ProcessManager(commandPattern)) : new ProcessManager(commandPattern);
        }
        return manager;
    }
}

