/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class EventService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.EventService");
    private static final Logger log = LogManager.getLogger(EventService.class);
    protected static final String XP = "listeners";
    protected Map<String, ListenerList> topics;
    protected Map<String, ListenerList> programmaticTopics;

    @Override
    public void activate(ComponentContext context) {
        this.programmaticTopics = new ConcurrentHashMap<String, ListenerList>();
    }

    @Override
    public void deactivate(ComponentContext context) {
        this.programmaticTopics = null;
    }

    @Override
    public void start(ComponentContext context) {
        this.topics = new HashMap<String, ListenerList>();
        this.getRegistryContributions(XP).forEach(desc -> {
            try {
                EventListener l = desc.getListener();
                for (String topic : desc.topics) {
                    this.topics.computeIfAbsent(topic, k -> new ListenerList()).add(l);
                }
            }
            catch (ReflectiveOperationException e) {
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, e.getMessage());
                log.error(e, (Throwable)e);
            }
        });
    }

    @Override
    public void stop(ComponentContext context) throws InterruptedException {
        this.topics = null;
    }

    public void sendEvent(Event event) {
        String topic = event.getTopic();
        ListenerList list = this.topics == null ? null : this.topics.get(topic);
        ListenerList plist = this.programmaticTopics.get(topic);
        if (list == null && plist == null) {
            if (log.isTraceEnabled()) {
                log.trace("No listener for event topic {}", (Object)topic);
            }
        } else {
            EventService.sendEvent(list, event);
            EventService.sendEvent(plist, event);
        }
    }

    public void addListener(String topic, EventListener listener) {
        this.programmaticTopics.computeIfAbsent(topic, k -> new ListenerList()).add(listener);
    }

    public void removeListener(String topic, EventListener listener) {
        ListenerList list = this.programmaticTopics.get(topic);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.programmaticTopics.remove(topic);
            }
        }
    }

    private static void sendEvent(ListenerList list, Event event) {
        Object[] listeners;
        if (list == null) {
            return;
        }
        for (Object listener : listeners = list.getListeners()) {
            ((EventListener)listener).handleEvent(event);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return (T)(adapter == this.getClass() ? this : null);
    }
}

