/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.impl.blob.ZipEntryBlob;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentReader;
import org.nuxeo.ecm.core.io.impl.DWord;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;

public class NuxeoArchiveReader
extends AbstractDocumentReader {
    private ZipInputStream in;
    private boolean inMustBeClosed;
    private ZipFile zipFile;
    private List<String> zipIndex;
    private final Collection<File> filesToDelete = new ArrayList<File>();

    public NuxeoArchiveReader(InputStream in) throws IOException {
        this(new ZipInputStream(in), true);
    }

    protected NuxeoArchiveReader(ZipInputStream in, boolean checkMarker) throws IOException {
        this.in = in;
        boolean bl = this.inMustBeClosed = !checkMarker;
        if (checkMarker) {
            this.checkMarker();
        }
    }

    public NuxeoArchiveReader(File file) throws IOException {
        this.zipFile = new ZipFile(file);
        this.buildOrderedZipIndex();
        this.checkMarker();
    }

    protected void buildOrderedZipIndex() {
        this.zipIndex = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            this.zipIndex.add(entry.getName());
        }
        this.zipIndex.sort(Comparator.naturalOrder());
    }

    @Override
    public ExportedDocument read() throws IOException {
        if (this.zipFile != null) {
            return this.readZip();
        }
        return this.readOrderedStream();
    }

    protected ExportedDocument readZip() throws IOException {
        if (this.zipIndex.size() == 0) {
            return null;
        }
        String idxname = this.zipIndex.remove(0);
        ZipEntry entry = this.zipFile.getEntry(idxname);
        if (entry == null) {
            return null;
        }
        if (!entry.isDirectory()) {
            if (entry.getName().equals(".nuxeo-archive")) {
                return this.read();
            }
            if (entry.getName().equals("document.xml")) {
                ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
                xdoc.setPath(new Path("/"));
                xdoc.setDocument(this.loadXML(entry));
                return xdoc;
            }
            throw new IOException("Invalid Nuxeo archive on entry " + entry.getName());
        }
        ArrayList<String> childEntries = new ArrayList<String>();
        int depth = new Path(idxname).removeTrailingSeparator().segmentCount();
        for (String path : this.zipIndex) {
            if (!path.startsWith(idxname)) break;
            int subdepth = new Path(path).removeTrailingSeparator().segmentCount();
            if (subdepth != depth + 1 || this.zipFile.getEntry(path).isDirectory()) continue;
            childEntries.add(path);
        }
        if (childEntries.size() == 0) {
            return this.read();
        }
        String name = entry.getName();
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        xdoc.setPath(new Path(name).removeTrailingSeparator());
        for (String childEntryName : childEntries) {
            int i = this.zipIndex.indexOf(childEntryName);
            idxname = this.zipIndex.remove(i);
            entry = this.zipFile.getEntry(idxname);
            name = entry.getName();
            if (name.endsWith("document.xml")) {
                xdoc.setDocument(this.loadXML(entry));
                continue;
            }
            if (name.endsWith(".xml")) {
                xdoc.putDocument(FilenameUtils.getBaseName((String)entry.getName()), this.loadXML(entry));
                continue;
            }
            xdoc.putBlob(FilenameUtils.getName((String)entry.getName()), this.createBlob(entry));
        }
        return xdoc;
    }

    protected ExportedDocument readOrderedStream() throws IOException {
        ZipEntry entry = this.in.getNextEntry();
        if (entry == null) {
            return null;
        }
        if (!entry.isDirectory()) {
            if (entry.getName().equals(".nuxeo-archive")) {
                return this.read();
            }
            if (entry.getName().equals("document.xml")) {
                ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
                xdoc.setPath(new Path("/"));
                xdoc.setDocument(this.loadXML(entry));
                return xdoc;
            }
            throw new IOException("Invalid Nuxeo archive");
        }
        int count = NuxeoArchiveReader.getFilesCount(entry);
        if (count == 0) {
            return this.read();
        }
        String name = entry.getName();
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        xdoc.setPath(new Path(name).removeTrailingSeparator());
        for (int i = 0; i < count; ++i) {
            entry = this.in.getNextEntry();
            name = entry.getName();
            if (name.endsWith("document.xml")) {
                xdoc.setDocument(this.loadXML(entry));
                continue;
            }
            if (name.endsWith(".xml")) {
                xdoc.putDocument(FilenameUtils.getBaseName((String)entry.getName()), this.loadXML(entry));
                continue;
            }
            xdoc.putBlob(FilenameUtils.getName((String)entry.getName()), this.createBlob(entry));
        }
        return xdoc;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.zipFile);
        if (this.inMustBeClosed) {
            IOUtils.closeQuietly((InputStream)this.in);
        }
        for (File file : this.filesToDelete) {
            file.delete();
        }
    }

    private static int getFilesCount(ZipEntry entry) throws IOException {
        byte[] bytes = entry.getExtra();
        if (bytes == null) {
            return 0;
        }
        if (bytes.length != 4) {
            throw new IOException("Invalid Nuxeo Archive");
        }
        return new DWord(bytes).getInt();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document loadXML(ZipEntry entry) throws IOException {
        try {
            SAXReader saxReader = new SAXReader();
            if (this.zipFile != null) {
                try (InputStream stream = this.zipFile.getInputStream(entry);){
                    Document document = saxReader.read(stream);
                    return document;
                }
            }
            try (CloseShieldInputStream ncin = new CloseShieldInputStream((InputStream)this.in);){
                Document document = saxReader.read((InputStream)ncin);
                return document;
            }
        }
        catch (DocumentException e) {
            throw new IOException("Failed to read zip entry: " + entry.getName(), e);
        }
    }

    private Blob createBlob(ZipEntry entry) throws IOException {
        if (this.zipFile != null) {
            return new ZipEntryBlob(this.zipFile, entry);
        }
        try (CloseShieldInputStream ncin = new CloseShieldInputStream((InputStream)this.in);){
            Blob blob = Blobs.createBlob((InputStream)ncin);
            this.filesToDelete.add(blob.getFile());
            Blob blob2 = blob;
            return blob2;
        }
    }

    private void checkMarker() throws IOException {
        if (this.zipFile == null) {
            ZipEntry entry = this.in.getNextEntry();
            if (entry == null) {
                throw new IOException("Not a valid Nuxeo Archive - no marker file found (unexpected end of zip)");
            }
            if (!NuxeoArchiveReader.isMarkerEntry(entry)) {
                throw new IOException("Not a valid Nuxeo Archive - no marker file found");
            }
        } else if (!this.zipIndex.contains(".nuxeo-archive")) {
            throw new IOException("Not a valid Nuxeo Archive - no marker file found");
        }
    }

    public static boolean isMarkerEntry(ZipEntry entry) {
        return entry.getName().equals(".nuxeo-archive");
    }
}

