/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import com.fasterxml.jackson.core.JsonGenerator;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.Enriched;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.context.WrappedContext;

public abstract class ExtensibleEntityJsonWriter<EntityType>
extends AbstractJsonWriter<EntityType> {
    private final String entityType;
    private final Type genericType;

    public ExtensibleEntityJsonWriter(String entityType, Class<EntityType> entityClass) {
        this.entityType = entityType;
        this.genericType = TypeUtils.parameterize(Enriched.class, (Type[])new Type[]{entityClass});
    }

    @Override
    public void write(EntityType entity, JsonGenerator jg) throws IOException {
        Span span;
        block11: {
            span = Tracing.getTracer().getCurrentSpan();
            span.addAnnotation("json#write " + this.entityType);
            jg.writeStartObject();
            ArrayList<String> entityList = new ArrayList<String>();
            entityList.add(this.entityType);
            this.ctx.addParameterListValues("ENTITY_TYPE", entityList);
            jg.writeStringField("entity-type", this.entityType);
            this.writeEntityBody(entity, jg);
            try {
                WrappedContext wrappedCtx = this.ctx.wrap().controlDepth();
                Set<String> enrichers = this.ctx.getEnrichers(this.entityType);
                if (enrichers.size() <= 0) break block11;
                boolean hasEnrichers = false;
                Enriched<EntityType> enriched = null;
                for (String enricherName : enrichers) {
                    span.addAnnotation("json#write " + this.entityType + ".enricher." + enricherName);
                    Closeable resource = wrappedCtx.with("_EntityEnricherName", enricherName).open();
                    try {
                        Collection<Writer<Enriched>> writers = this.registry.getAllWriters(this.ctx, Enriched.class, this.genericType, MediaType.APPLICATION_JSON_TYPE);
                        for (Writer<Enriched> writer : writers) {
                            if (!hasEnrichers) {
                                hasEnrichers = true;
                                jg.writeObjectFieldStart("contextParameters");
                                enriched = new Enriched<EntityType>(entity);
                            }
                            OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                            writer.write(enriched, Enriched.class, this.genericType, MediaType.APPLICATION_JSON_TYPE, out);
                        }
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                if (hasEnrichers) {
                    jg.writeEndObject();
                }
            }
            catch (MaxDepthReachedException maxDepthReachedException) {
                // empty catch block
            }
        }
        this.extend(entity, jg);
        jg.writeEndObject();
        span.addAnnotation("json#write " + this.entityType + ".done");
    }

    protected abstract void writeEntityBody(EntityType var1, JsonGenerator var2) throws IOException;

    protected void extend(EntityType entity, JsonGenerator jg) throws IOException {
    }
}

