/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.pdf.PDFUtils;
import org.nuxeo.runtime.api.Framework;

public class PDFMerge {
    private BlobList blobs = new BlobList();

    public PDFMerge() {
    }

    public PDFMerge(Blob inBlob) {
        this.addBlob(inBlob);
    }

    public PDFMerge(BlobList inBlobs) {
        this.addBlobs(inBlobs);
    }

    public PDFMerge(DocumentModel inDoc, String inXPath) {
        this.addBlob(inDoc, inXPath);
    }

    public PDFMerge(DocumentModelList inDocs, String inXPath) {
        this.addBlobs(inDocs, inXPath);
    }

    public PDFMerge(String[] inDocIDs, String inXPath, CoreSession inSession) {
        this.addBlobs(inDocIDs, inXPath, inSession);
    }

    public void addBlob(Blob inBlob) {
        if (inBlob != null) {
            this.blobs.add((Object)inBlob);
        }
    }

    public void addBlobs(BlobList inBlobs) {
        inBlobs.forEach(this::addBlob);
    }

    public void addBlob(DocumentModel inDoc, String inXPath) {
        if (inXPath == null || inXPath.isEmpty()) {
            inXPath = "file:content";
        }
        this.addBlob((Blob)inDoc.getPropertyValue(inXPath));
    }

    public void addBlobs(DocumentModelList inDocs, String inXPath) {
        for (DocumentModel doc : inDocs) {
            this.addBlob(doc, inXPath);
        }
    }

    public void addBlobs(String[] inDocIDs, String inXPath, CoreSession inSession) {
        for (String id : inDocIDs) {
            DocumentModel doc = inSession.getDocument((DocumentRef)new IdRef(id));
            this.addBlob(doc, inXPath);
        }
    }

    public Blob merge(String inFileName) throws IOException {
        return this.merge(inFileName, null, null, null);
    }

    public Blob merge(String inFileName, String inTitle, String inSubject, String inAuthor) throws IOException {
        Blob finalBlob;
        switch (this.blobs.size()) {
            case 0: {
                finalBlob = null;
                break;
            }
            case 1: {
                finalBlob = (Blob)this.blobs.get(0);
                break;
            }
            default: {
                PDFMergerUtility ut = new PDFMergerUtility();
                for (Blob b : this.blobs) {
                    ut.addSource(b.getStream());
                }
                File tempFile = File.createTempFile("mergepdf", ".pdf");
                ut.setDestinationFileName(tempFile.getAbsolutePath());
                ut.mergeDocuments();
                if (inTitle != null || inAuthor != null || inSubject != null) {
                    PDDocument finalDoc = PDDocument.load((File)tempFile);
                    PDFUtils.setInfos(finalDoc, inTitle, inSubject, inAuthor);
                    finalDoc.save(tempFile);
                    finalDoc.close();
                }
                finalBlob = new FileBlob(tempFile);
                Framework.trackFile((File)tempFile, (Object)finalBlob);
                if (inFileName != null && !inFileName.isEmpty()) {
                    finalBlob.setFilename(inFileName);
                } else {
                    finalBlob.setFilename(((Blob)this.blobs.get(0)).getFilename());
                }
                finalBlob.setMimeType("application/pdf");
            }
        }
        return finalBlob;
    }
}

