/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.nuxeo.ecm.web.resources.api.Processor;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceBundle;
import org.nuxeo.ecm.web.resources.api.ResourceContext;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebResourceManagerImpl
extends DefaultComponent
implements WebResourceManager {
    private static final Logger log = LogManager.getLogger(WebResourceManagerImpl.class);
    public static final String COMPONENT_NAME = "org.nuxeo.ecm.platform.WebResources";
    public static final String RESOURCES_ENDPOINT = "resources";
    protected static final String RESOURCE_BUNDLES_ENDPOINT = "bundles";
    protected static final String PROCESSORS_ENDPOINT = "processors";

    public Resource getResource(String name) {
        return this.getRegistryContribution(RESOURCES_ENDPOINT, name).orElse(null);
    }

    public ResourceBundle getResourceBundle(String name) {
        return this.getRegistryContribution(RESOURCE_BUNDLES_ENDPOINT, name).orElse(null);
    }

    public List<ResourceBundle> getResourceBundles() {
        return this.getRegistryContributions(RESOURCE_BUNDLES_ENDPOINT);
    }

    public Processor getProcessor(String name) {
        return this.getRegistryContribution(PROCESSORS_ENDPOINT, name).orElse(null);
    }

    public List<Processor> getProcessors() {
        return this.getRegistryContributions(PROCESSORS_ENDPOINT);
    }

    public List<Processor> getProcessors(String type) {
        return this.getProcessors().stream().filter(p -> type == null || p.getTypes().contains(type)).sorted().collect(Collectors.toList());
    }

    public List<Resource> getResources(ResourceContext context, String bundleName, String type) {
        Resource r;
        ArrayList<Resource> res = new ArrayList<Resource>();
        ResourceBundle rb = this.getResourceBundle(bundleName);
        if (rb == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Unknown bundle named '%s'", bundleName));
            }
            return res;
        }
        HashMap<String, Resource> all = new HashMap<String, Resource>();
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        for (String rn : rb.getResources()) {
            r = this.getResource(rn);
            if (r == null) {
                log.error("Could not resolve resource '{}' on bundle '{}'", (Object)rn, (Object)bundleName);
                continue;
            }
            Map<String, Resource> subRes = this.getSubResources((DirectedAcyclicGraph<String, DefaultEdge>)graph, r, type);
            if (!ResourceType.matches((String)type, (Resource)r) && subRes.isEmpty()) continue;
            graph.addVertex((Object)rn);
            all.put(rn, r);
            all.putAll(subRes);
        }
        for (String rn : graph) {
            r = (Resource)all.get(rn);
            if (!ResourceType.matches((String)type, (Resource)r)) continue;
            res.add(r);
        }
        return res;
    }

    protected Map<String, Resource> getSubResources(DirectedAcyclicGraph<String, DefaultEdge> graph, Resource r, String type) {
        HashMap<String, Resource> res = new HashMap<String, Resource>();
        List deps = r.getDependencies();
        if (deps != null) {
            for (String dn : deps) {
                Resource d = this.getResource(dn);
                if (d == null) {
                    log.error("Unknown resource dependency named '{}'", (Object)dn);
                    continue;
                }
                if (!ResourceType.matches((String)type, (Resource)d)) continue;
                res.put(dn, d);
                graph.addVertex((Object)dn);
                graph.addVertex((Object)r.getName());
                try {
                    graph.addEdge((Object)dn, (Object)r.getName());
                }
                catch (IllegalArgumentException e) {
                    log.error("Cycle detected in resource dependencies: ", (Throwable)e);
                    break;
                }
                res.putAll(this.getSubResources(graph, d, type));
            }
        }
        return res;
    }
}

