/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WidgetTypeDefinitionJsonWriter
extends AbstractJsonWriter<WidgetTypeDefinition> {
    public void write(WidgetTypeDefinition entity, JsonGenerator jg) throws IOException {
        WidgetTypeConfiguration configuration;
        jg.writeStartObject();
        jg.writeStringField("name", entity.getName());
        List aliases = entity.getAliases();
        if (CollectionUtils.isNotEmpty((Collection)aliases)) {
            this.writeSerializableListField("aliases", aliases, jg);
        }
        jg.writeStringField("handlerClassName", entity.getHandlerClassName());
        Map properties = entity.getProperties();
        if (MapUtils.isNotEmpty((Map)properties)) {
            this.writeSerializableMapField("properties", new TreeMap(properties), jg);
        }
        if ((configuration = entity.getConfiguration()) != null) {
            this.writeEntityField("configuration", configuration, jg);
        }
        jg.writeEndObject();
    }
}

