/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.factory;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.util.AbstractDecorator;

public class InjectableUriLocatorFactoryDecorator
extends AbstractDecorator<UriLocatorFactory>
implements UriLocatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InjectableUriLocatorFactoryDecorator.class);
    @Inject
    private Injector injector;

    public InjectableUriLocatorFactoryDecorator(UriLocatorFactory decorated) {
        super(decorated);
    }

    @Override
    public InputStream locate(String uri) throws IOException {
        UriLocator locator = this.getInstance(uri);
        if (locator == null) {
            return ((UriLocatorFactory)this.getDecoratedObject()).locate(uri);
        }
        return locator.locate(uri);
    }

    @Override
    public UriLocator getInstance(String uri) {
        UriLocator instance = ((UriLocatorFactory)this.getDecoratedObject()).getInstance(uri);
        if (instance != null) {
            LOG.debug("using {} locator for uri: {}", (Object)instance, (Object)uri);
            this.injector.inject(instance);
        }
        return instance;
    }
}

