/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mvel2.CompileException;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.events.DocumentAttributeFilterFactory;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventContext;

@XObject(value="handler")
@XRegistry(merge=false, remove=false, enable=false)
public class EventHandler {
    private static final Log log = LogFactory.getLog(EventHandler.class);
    @XNode(value="@chainId")
    protected String chainId;
    @XNode(value="@postCommit")
    protected boolean isPostCommit;
    @XNodeList(value="event", type=HashSet.class, componentType=String.class)
    protected Set<String> events;
    @XNodeList(value="filters/doctype", type=HashSet.class, componentType=String.class, nullByDefault=true)
    protected Set<String> doctypes;
    @XNode(value="filters/facet")
    protected String facet;
    protected String[] lifeCycle;
    @XNode(value="filters/pathStartsWith")
    protected String pathStartsWith;
    protected Filter attribute;
    @XNodeList(value="filters/group", type=ArrayList.class, componentType=String.class)
    protected List<String> memberOf;
    @XNode(value="filters/isAdministrator")
    protected Boolean isAdministrator;
    protected String condition;

    @XNode(value="filters/lifeCycle")
    protected void setLifeCycleExpr(String lifeCycles) {
        this.lifeCycle = StringUtils.split((String)lifeCycles, (char)',', (boolean)true);
    }

    @XNode(value="filters/attribute")
    public void setAttribute(String attribute) {
        this.attribute = DocumentAttributeFilterFactory.getFilter(attribute);
    }

    @XNode(value="filters/condition")
    protected void _setCondition(String expr) {
        this.condition = this.convertExpr(expr);
    }

    protected String convertExpr(String expr) {
        String res = expr.replace("&lt;", "<");
        res = res.replace("&gt;", ">");
        res = res.replace("&amp;", "&");
        return res;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public String getChainId() {
        return this.chainId;
    }

    public boolean isPostCommit() {
        return this.isPostCommit;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getFacet() {
        return this.facet;
    }

    public Filter getAttribute() {
        return this.attribute;
    }

    public String[] getLifeCycle() {
        return this.lifeCycle;
    }

    public List<String> getMemberOf() {
        return this.memberOf;
    }

    public Boolean getIsAdministrator() {
        return this.isAdministrator;
    }

    public String getPathStartsWith() {
        return this.pathStartsWith;
    }

    public Set<String> getDoctypes() {
        return this.doctypes;
    }

    public boolean isEnabled(OperationContext ctx, EventContext eventCtx, boolean quick) {
        Object obj = ctx.getInput();
        DocumentModel doc = null;
        if (obj instanceof DocumentModel) {
            doc = (DocumentModel)obj;
        }
        if (this.doctypes != null && (doc == null || !this.doctypes.isEmpty() && !this.doctypes.contains(doc.getType()))) {
            return false;
        }
        if (!(this.facet == null || doc != null && doc.hasFacet(this.facet))) {
            return false;
        }
        if (this.lifeCycle != null && this.lifeCycle.length > 0) {
            if (doc == null) {
                return false;
            }
            boolean match = false;
            String currentLc = doc.getCurrentLifeCycleState();
            for (String lc : this.lifeCycle) {
                if (!lc.equals(currentLc)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (!(this.attribute == null || doc != null && this.attribute.accept(doc))) {
            return false;
        }
        if (!(this.pathStartsWith == null || doc != null && doc.getPathAsString().startsWith(this.pathStartsWith))) {
            return false;
        }
        if (this.memberOf != null && !this.memberOf.isEmpty()) {
            NuxeoPrincipal p = eventCtx.getPrincipal();
            boolean granted = false;
            for (String group : this.memberOf) {
                if (!p.isMemberOf(group)) continue;
                granted = true;
                break;
            }
            if (!granted) {
                return false;
            }
        }
        if (this.isAdministrator != null && !eventCtx.getPrincipal().isAdministrator()) {
            return false;
        }
        if (quick) {
            return true;
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.condition)) {
            Expression expr = Scripting.newExpression(this.condition);
            try {
                if (!Boolean.TRUE.equals(expr.eval(ctx))) {
                    return false;
                }
            }
            catch (CompileException e) {
                log.debug((Object)("Failed to execute expression: " + e), (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

