/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.AbstractRegistry;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public class EventHandlerRegistry
extends AbstractRegistry {
    private static final Logger log = LogManager.getLogger(EventHandlerRegistry.class);
    protected Map<String, List<EventHandler>> handlers = new ConcurrentHashMap<String, List<EventHandler>>();
    protected Map<String, List<EventHandler>> postCommitHandlers = new ConcurrentHashMap<String, List<EventHandler>>();

    public void initialize() {
        this.handlers.clear();
        this.postCommitHandlers.clear();
        super.initialize();
    }

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        EventHandler eh = (EventHandler)this.getInstance(ctx, xObject, element);
        if (eh.isPostCommit()) {
            eh.getEvents().forEach(e -> this.postCommitHandlers.computeIfAbsent((String)e, k -> new ArrayList()).add(eh));
        } else {
            eh.getEvents().forEach(e -> this.handlers.computeIfAbsent((String)e, k -> new ArrayList()).add(eh));
        }
        return null;
    }

    public List<EventHandler> getEventHandlers(String eventId) {
        return this.handlers.get(eventId);
    }

    public List<EventHandler> getPostCommitEventHandlers(String eventId) {
        return this.postCommitHandlers.get(eventId);
    }

    public Set<String> getPostCommitEventNames() {
        return this.postCommitHandlers.keySet();
    }

    public boolean acceptEvent(Event event, List<EventHandler> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            return false;
        }
        try (OperationContext ctx = this.open(event);){
            EventContext ectx = event.getContext();
            ctx.put("Event", (Object)event);
            for (EventHandler handler : handlers) {
                if (!handler.isEnabled(ctx, ectx, true)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected OperationContext open(Event event) {
        EventContext ectx = event.getContext();
        if (ectx instanceof DocumentEventContext) {
            OperationContext ctx = new OperationContext(ectx.getCoreSession());
            ctx.setInput(((DocumentEventContext)ectx).getSourceDocument());
            return ctx;
        }
        return new OperationContext();
    }

    public void handleEvent(Event event, List<EventHandler> handlers, boolean saveSession) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        EventContext ectx = event.getContext();
        AutomationService svc = (AutomationService)Framework.getService(AutomationService.class);
        for (EventHandler handler : handlers) {
            try {
                OperationContext ctx = this.getContext(ectx);
                try {
                    ctx.put("Event", (Object)event);
                    ctx.setCommit(saveSession);
                    if (!handler.isEnabled(ctx, ectx, false)) continue;
                    svc.run(ctx, handler.getChainId());
                }
                finally {
                    if (ctx == null) continue;
                    ctx.close();
                }
            }
            catch (OperationException e) {
                log.error("Failed to handle event '{}' using chain '{}'", (Object)event.getName(), (Object)handler.getChainId(), (Object)e);
                throw new NuxeoException((Throwable)e);
            }
            catch (NuxeoException e) {
                log.error("Failed to handle event '{}' using chain '{}'", (Object)event.getName(), (Object)handler.getChainId(), (Object)e);
                throw e;
            }
        }
    }

    protected OperationContext getContext(EventContext ectx) {
        if (ectx instanceof DocumentEventContext) {
            OperationContext ctx = new OperationContext(ectx.getCoreSession());
            ctx.setInput(((DocumentEventContext)ectx).getSourceDocument());
            return ctx;
        }
        return new OperationContext();
    }
}

