/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.RegistryContribution;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationRegistry;
import org.nuxeo.ecm.automation.core.impl.OperationRegistryContribution;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public class ChainRegistry
extends MapRegistry {
    protected static OperationRegistry getTargetRegistry() {
        return (OperationRegistry)((Object)Framework.getRuntime().getComponentManager().getExtensionPointRegistry("org.nuxeo.ecm.automation.core.AutomationComponent", "operations").orElseThrow(() -> new IllegalArgumentException(String.format("Unknown target registry %s--%s", "org.nuxeo.ecm.automation.core.AutomationComponent", "operations"))));
    }

    public void tag(String id) {
        ChainRegistry.getTargetRegistry().tag(id);
    }

    public boolean isTagged(String id) {
        return ChainRegistry.getTargetRegistry().isTagged(id);
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        String id = this.computeId(ctx, xObject, element);
        try {
            OperationChainContribution occ = (OperationChainContribution)this.getInstance(ctx, xObject, element);
            if (!occ.isReplace() && this.contributions.containsKey(id)) {
                throw new RuntimeServiceException("An operation is already bound to id '" + id + "': use 'replace=\"true\"' to replace an existing operation");
            }
            OperationChain chain = occ.toOperationChain(ctx);
            ChainTypeImpl contrib = new ChainTypeImpl(chain, occ, OperationRegistry.getContributingComponentId(tag));
            OperationRegistryContribution registration = new OperationRegistryContribution(ctx, xObject, element, tag, contrib.getId(), occ.isReplace(), contrib.getAliases(), contrib);
            ChainRegistry.getTargetRegistry().register(registration, tag);
        }
        catch (OperationException e) {
            String extensionId = RegistryContribution.getRuntimeExtensionFromTag((String)tag);
            String msg = String.format("Failed to register chain with id '%s' in component '%s' (%s)", id, extensionId, e.toString());
            Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, msg, RuntimeMessage.Source.EXTENSION, extensionId));
        }
    }

    public void unregister(String tag) {
        ChainRegistry.getTargetRegistry().unregister(tag);
    }
}

