/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;

public class DirectoryRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(DirectoryRegistry.class);
    protected Map<String, BaseDirectoryDescriptor> descriptors = new ConcurrentHashMap<String, BaseDirectoryDescriptor>();
    protected Map<String, Directory> directories = new ConcurrentHashMap<String, Directory>();

    public void initialize() {
        this.shutdown();
        this.directories.clear();
        this.descriptors.clear();
        super.initialize();
        for (String id : this.getContributions().keySet()) {
            BaseDirectoryDescriptor desc = this.computeFinalDescriptor(id, new HashSet<String>());
            if (desc == null || desc.template) continue;
            this.descriptors.put(id, desc);
        }
    }

    protected BaseDirectoryDescriptor computeFinalDescriptor(String id, Set<String> done) {
        BaseDirectoryDescriptor desc = this.getBareDirectoryDescriptor(id);
        if (done.contains(id)) {
            return desc;
        }
        done.add(id);
        if (desc == null) {
            return null;
        }
        String extendz = desc.extendz;
        if (extendz == null) {
            return desc;
        }
        BaseDirectoryDescriptor base = this.computeFinalDescriptor(extendz, done);
        if (base == null || !base.template) {
            String message = String.format("Directory '%s' extends non-existing directory template: '%s'", id, extendz);
            log.error(message);
            Framework.getRuntime().getMessageHandler().addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, message, RuntimeMessage.Source.COMPONENT, "org.nuxeo.ecm.directory.DirectoryServiceImpl"));
            return null;
        }
        BaseDirectoryDescriptor finalDesc = base.clone();
        finalDesc.template = false;
        finalDesc.name = id;
        finalDesc.merge(desc);
        return finalDesc;
    }

    public BaseDirectoryDescriptor getDirectoryDescriptor(String id) {
        this.checkInitialized();
        BaseDirectoryDescriptor descriptor = this.descriptors.get(id);
        if (descriptor == null) {
            return null;
        }
        return descriptor.template ? null : descriptor;
    }

    public Directory getDirectory(String id) {
        BaseDirectoryDescriptor descriptor;
        Directory dir = this.directories.get(id);
        if (dir == null && (descriptor = this.descriptors.get(id)) != null && !descriptor.template) {
            dir = descriptor.newDirectory();
            this.directories.put(id, dir);
        }
        return dir;
    }

    public List<String> getDirectoryIds() {
        return this.descriptors.values().stream().filter(desc -> !desc.template).map(desc -> desc.name).collect(Collectors.toList());
    }

    public List<Directory> getDirectories() {
        return this.descriptors.values().stream().filter(desc -> !desc.template).map(desc -> this.getDirectory(desc.name)).collect(Collectors.toList());
    }

    public synchronized void shutdown() {
        for (Directory dir : this.directories.values()) {
            try {
                dir.shutdown();
            }
            catch (DirectoryException e) {
                log.error("Error while shutting down directory: {}", (Object)dir.getName(), (Object)e);
            }
        }
    }

    protected BaseDirectoryDescriptor getBareDirectoryDescriptor(String name) {
        return this.getContribution(name).map(c -> this.getTargetRegistry(c.target, c.point)).flatMap(r -> r.getContribution(name)).orElse(null);
    }

    protected MapRegistry getTargetRegistry(String component, String point) {
        return (MapRegistry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry(component, point).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown registry for extension point '%s--%s'", component, point)));
    }
}

