/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.scroll;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.SearchHit;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.scroll.RepositoryScroll;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchScroll
extends RepositoryScroll {
    protected EsScrollResult esScroll;

    public boolean hasNext() {
        if (this.hasNextResult == null) {
            this.hasNextResult = this.fetch();
        }
        return this.hasNextResult;
    }

    protected boolean fetch() {
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        try {
            this.esScroll = this.esScroll == null ? ess.scroll(new NxQueryBuilder(this.session).nxql(this.request.getQuery()).limit(this.request.getSize()).onlyElasticsearchResponse(), this.request.getTimeout().toSeconds()) : ess.scroll(this.esScroll);
        }
        catch (ElasticsearchException e) {
            throw new NuxeoException("Elastic scroll failure on request: " + this.request, (Throwable)e);
        }
        SearchHit[] hits = this.esScroll.getElasticsearchResponse().getHits().getHits();
        return hits != null && hits.length > 0;
    }

    public List<String> next() {
        if (this.hasNextResult == null) {
            this.hasNextResult = this.fetch();
        }
        if (!this.hasNextResult.booleanValue()) {
            throw new NoSuchElementException();
        }
        this.hasNextResult = null;
        SearchHit[] hits = this.esScroll.getElasticsearchResponse().getHits().getHits();
        return Arrays.stream(hits).map(SearchHit::getId).collect(Collectors.toList());
    }

    public void close() {
        super.close();
        this.esScroll = null;
    }
}

