/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSCachingConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSClusterInvalidator;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.dbs.GuavaCacheMetric;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.metrics.MetricsService;

public class DBSCachingRepository
implements DBSRepository {
    private static final Log log = LogFactory.getLog(DBSCachingRepository.class);
    protected static final String METRIC_CACHE_NAME = "nuxeo.repositories.repository.cache";
    protected static final String METRIC_CHILD_CACHE_NAME = "nuxeo.repositories.repository.childCache";
    private final DBSRepository repository;
    protected final Cache<String, State> cache;
    protected final Cache<String, String> childCache;
    protected final DBSRepositoryDescriptor descriptor;
    protected final DBSInvalidationsPropagator invalidationsPropagator;
    protected final DBSClusterInvalidator clusterInvalidator;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());

    public DBSCachingRepository(DBSRepository repository, DBSRepositoryDescriptor descriptor) {
        this.repository = repository;
        this.descriptor = descriptor;
        if (this.supportsTransactions()) {
            this.cache = null;
            this.childCache = null;
        } else {
            this.cache = this.newCache(true);
            this.childCache = this.newChildCache(true);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("DBS cache activated on '%s' repository", this.getName()));
        }
        this.invalidationsPropagator = this.initInvalidationsPropagator();
        this.clusterInvalidator = this.initClusterInvalidator(descriptor);
    }

    protected Cache<String, State> getCache() {
        return this.cache;
    }

    protected Cache<String, String> getChildCache() {
        return this.childCache;
    }

    protected DBSInvalidationsPropagator getInvalidationsPropagator() {
        return this.invalidationsPropagator;
    }

    protected DBSClusterInvalidator getClusterInvalidator() {
        return this.clusterInvalidator;
    }

    protected Cache<String, State> newCache(boolean metrics) {
        Cache c = this.newCache(this.descriptor);
        if (metrics) {
            this.registry.registerAll(GuavaCacheMetric.of(c, MetricName.build((String[])new String[]{METRIC_CACHE_NAME}).tagged(new String[]{"repository", this.repository.getName()})));
        }
        return c;
    }

    protected Cache<String, String> newChildCache(boolean metrics) {
        Cache c = this.newCache(this.descriptor);
        if (metrics) {
            this.registry.registerAll(GuavaCacheMetric.of(c, MetricName.build((String[])new String[]{METRIC_CHILD_CACHE_NAME}).tagged(new String[]{"repository", this.repository.getName()})));
        }
        return c;
    }

    protected void removeCacheMetrics() {
        this.registry.removeMatching((name, metric) -> name.getKey().startsWith(METRIC_CACHE_NAME) || name.getKey().startsWith(METRIC_CHILD_CACHE_NAME));
    }

    protected <T> Cache<String, T> newCache(DBSRepositoryDescriptor descriptor) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder = builder.expireAfterWrite(descriptor.cacheTTL.longValue(), TimeUnit.MINUTES).recordStats();
        if (descriptor.cacheConcurrencyLevel != null) {
            builder = builder.concurrencyLevel(descriptor.cacheConcurrencyLevel.intValue());
        }
        if (descriptor.cacheMaxSize != null) {
            builder = builder.maximumSize(descriptor.cacheMaxSize.longValue());
        }
        return builder.build();
    }

    protected DBSInvalidationsPropagator initInvalidationsPropagator() {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        if (clusterService.isEnabled() && this.supportsTransactions()) {
            return new DBSInvalidationsPropagator();
        }
        return null;
    }

    protected DBSClusterInvalidator initClusterInvalidator(DBSRepositoryDescriptor descriptor) {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        if (clusterService.isEnabled()) {
            DBSClusterInvalidator ci = this.createClusterInvalidator(descriptor);
            ci.initialize(clusterService.getNodeId(), this.getName());
            return ci;
        }
        return null;
    }

    protected DBSClusterInvalidator createClusterInvalidator(DBSRepositoryDescriptor descriptor) {
        Class<? extends DBSClusterInvalidator> klass = descriptor.clusterInvalidatorClass;
        if (klass == null) {
            throw new NuxeoException("Unable to get cluster invalidator class from descriptor whereas clustering is enabled");
        }
        try {
            return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public void shutdown() {
        this.repository.shutdown();
        if (this.cache != null) {
            this.cache.invalidateAll();
            this.childCache.invalidateAll();
        }
        this.removeCacheMetrics();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("DBS cache deactivated on '%s' repository", this.getName()));
        }
    }

    @Override
    public DBSConnection getConnection() {
        DBSConnection connection = this.repository.getConnection();
        return new DBSCachingConnection(connection, this);
    }

    @Override
    public boolean supportsTransactions() {
        return this.repository.supportsTransactions();
    }

    @Override
    public BlobManager getBlobManager() {
        return this.repository.getBlobManager();
    }

    public FulltextConfiguration getFulltextConfiguration() {
        return this.repository.getFulltextConfiguration();
    }

    @Override
    public boolean isFulltextDisabled() {
        return this.repository.isFulltextDisabled();
    }

    @Override
    public boolean isFulltextStoredInBlob() {
        return this.repository.isFulltextStoredInBlob();
    }

    @Override
    public boolean isFulltextSearchDisabled() {
        return this.repository.isFulltextSearchDisabled();
    }

    @Override
    public boolean isChangeTokenEnabled() {
        return this.repository.isChangeTokenEnabled();
    }

    @Override
    public LockManager getLockManager() {
        return this.repository.getLockManager();
    }

    public Lock getLock(String id) {
        return this.repository.getLock(id);
    }

    public Lock setLock(String id, Lock lock) {
        return this.repository.setLock(id, lock);
    }

    public Lock removeLock(String id, String owner) {
        return this.repository.removeLock(id, owner);
    }

    public void closeLockManager() {
        this.repository.closeLockManager();
    }

    public void clearLockManagerCaches() {
        this.repository.clearLockManagerCaches();
    }

    public String getName() {
        return this.repository.getName();
    }

    public Session getSession() {
        return new DBSSession(this);
    }

    public void markReferencedBinaries() {
        this.repository.markReferencedBinaries();
    }

    public Object getCapability(String name) {
        return this.repository.getCapability(name);
    }

    @Override
    public List<List<String>> getBlobKeysPaths() {
        return this.repository.getBlobKeysPaths();
    }
}

