/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.lock.LockManager;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.VersionNotModifiableException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.BaseDocument;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateAccessor;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.runtime.api.Framework;

public class DBSDocument
extends BaseDocument<State> {
    private static final Long ZERO = 0L;
    public static final String SYSPROP_FULLTEXT_SIMPLE = "fulltextSimple";
    public static final String SYSPROP_FULLTEXT_BINARY = "fulltextBinary";
    public static final String SYSPROP_FULLTEXT_JOBID = "fulltextJobId";
    public static final String SYSPROP_IS_TRASHED = "isTrashed";
    public static final String KEY_PREFIX = "ecm:";
    public static final String KEY_ID = "ecm:id";
    public static final String KEY_PARENT_ID = "ecm:parentId";
    public static final String KEY_ANCESTOR_IDS = "ecm:ancestorIds";
    public static final String KEY_PRIMARY_TYPE = "ecm:primaryType";
    public static final String KEY_MIXIN_TYPES = "ecm:mixinTypes";
    public static final String KEY_NAME = "ecm:name";
    public static final String KEY_POS = "ecm:pos";
    public static final String KEY_ACP = "ecm:acp";
    public static final String KEY_ACL_NAME = "name";
    public static final String KEY_PATH_INTERNAL = "ecm:__path";
    public static final String KEY_ACL = "acl";
    public static final String KEY_ACE_USER = "user";
    public static final String KEY_ACE_PERMISSION = "perm";
    public static final String KEY_ACE_GRANT = "grant";
    public static final String KEY_ACE_CREATOR = "creator";
    public static final String KEY_ACE_BEGIN = "begin";
    public static final String KEY_ACE_END = "end";
    public static final String KEY_ACE_STATUS = "status";
    public static final String KEY_READ_ACL = "ecm:racl";
    public static final String KEY_IS_RECORD = "ecm:isRecord";
    public static final String KEY_RETAIN_UNTIL = "ecm:retainUntil";
    public static final String KEY_HAS_LEGAL_HOLD = "ecm:hasLegalHold";
    @Deprecated
    public static final String KEY_IS_RETENTION_ACTIVE = "ecm:isRetentionActive";
    public static final String KEY_IS_CHECKED_IN = "ecm:isCheckedIn";
    public static final String KEY_IS_VERSION = "ecm:isVersion";
    public static final String KEY_IS_LATEST_VERSION = "ecm:isLatestVersion";
    public static final String KEY_IS_LATEST_MAJOR_VERSION = "ecm:isLatestMajorVersion";
    public static final String KEY_MAJOR_VERSION = "ecm:majorVersion";
    public static final String KEY_MINOR_VERSION = "ecm:minorVersion";
    public static final String KEY_VERSION_SERIES_ID = "ecm:versionSeriesId";
    public static final String KEY_VERSION_CREATED = "ecm:versionCreated";
    public static final String KEY_VERSION_LABEL = "ecm:versionLabel";
    public static final String KEY_VERSION_DESCRIPTION = "ecm:versionDescription";
    public static final String KEY_BASE_VERSION_ID = "ecm:baseVersionId";
    public static final String KEY_IS_PROXY = "ecm:isProxy";
    public static final String KEY_PROXY_TARGET_ID = "ecm:proxyTargetId";
    public static final String KEY_PROXY_VERSION_SERIES_ID = "ecm:proxyVersionSeriesId";
    public static final String KEY_PROXY_IDS = "ecm:proxyIds";
    public static final String KEY_LIFECYCLE_POLICY = "ecm:lifeCyclePolicy";
    public static final String KEY_LIFECYCLE_STATE = "ecm:lifeCycleState";
    public static final String KEY_IS_TRASHED = "ecm:isTrashed";
    public static final String KEY_LOCK_OWNER = "ecm:lockOwner";
    public static final String KEY_LOCK_CREATED = "ecm:lockCreated";
    public static final String KEY_SYS_CHANGE_TOKEN = "ecm:systemChangeToken";
    public static final String KEY_CHANGE_TOKEN = "ecm:changeToken";
    public static final String KEY_DC_MODIFIED = "dc:modified";
    public static final String KEY_BLOB_NAME = "name";
    public static final String KEY_BLOB_MIME_TYPE = "mime-type";
    public static final String KEY_BLOB_ENCODING = "encoding";
    public static final String KEY_BLOB_DIGEST = "digest";
    public static final String KEY_BLOB_LENGTH = "length";
    public static final String KEY_BLOB_DATA = "data";
    public static final String KEY_BLOB_KEYS = "ecm:blobKeys";
    public static final String KEY_FULLTEXT_SIMPLE = "ecm:fulltextSimple";
    public static final String KEY_FULLTEXT_BINARY = "ecm:fulltextBinary";
    public static final String KEY_FULLTEXT_JOBID = "ecm:fulltextJobId";
    public static final String KEY_FULLTEXT_SCORE = "ecm:fulltextScore";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String PROP_UID_MAJOR_VERSION = "uid:major_version";
    public static final String PROP_UID_MINOR_VERSION = "uid:minor_version";
    public static final String PROP_MAJOR_VERSION = "major_version";
    public static final String PROP_MINOR_VERSION = "minor_version";
    public static final String FACETED_TAG = "nxtag:tags";
    public static final String FACETED_TAG_LABEL = "label";
    public static final Long INITIAL_SYS_CHANGE_TOKEN = 0L;
    public static final Long INITIAL_CHANGE_TOKEN = 0L;
    protected final String id;
    protected final DBSDocumentState docState;
    protected final DocumentType type;
    protected final List<Schema> proxySchemas;
    protected final DBSSession session;
    protected boolean readonly;
    protected static final Map<String, String> systemPropNameMap = new HashMap<String, String>();
    public static final String CHANGE_TOKEN_PROXY_SEP = "/";

    public DBSDocument(DBSDocumentState docState, DocumentType type, DBSSession session, boolean readonly) {
        this.id = docState == null ? null : (String)((Object)docState.get(KEY_ID));
        this.docState = docState;
        this.type = type;
        this.session = session;
        if (docState != null && this.isProxy()) {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            this.proxySchemas = schemaManager.getProxySchemas(type.getName());
        } else {
            this.proxySchemas = null;
        }
        this.readonly = readonly;
    }

    public DocumentType getType() {
        return this.type;
    }

    public Session getSession() {
        return this.session;
    }

    public String getRepositoryName() {
        return this.session.getRepositoryName();
    }

    protected List<Schema> getProxySchemas() {
        return this.proxySchemas;
    }

    public String getUUID() {
        return this.id;
    }

    public String getName() {
        return this.docState.getName();
    }

    public Long getPos() {
        return (Long)this.docState.get(KEY_POS);
    }

    public Document getParent() {
        if (this.isVersion()) {
            DBSDocument workingCopy = this.session.getDocument(this.getVersionSeriesId());
            return workingCopy == null ? null : workingCopy.getParent();
        }
        String parentId = this.docState.getParentId();
        return parentId == null ? null : this.session.getDocument(parentId);
    }

    public boolean isProxy() {
        return Boolean.TRUE.equals(this.docState.get(KEY_IS_PROXY));
    }

    public boolean isVersion() {
        return Boolean.TRUE.equals(this.docState.get(KEY_IS_VERSION));
    }

    public String getPath() {
        if (this.isVersion()) {
            DBSDocument workingCopy = this.session.getDocument(this.getVersionSeriesId());
            return workingCopy == null ? null : workingCopy.getPath();
        }
        String name = this.getName();
        Document doc = this.getParent();
        if (doc == null) {
            if ("".equals(name)) {
                return CHANGE_TOKEN_PROXY_SEP;
            }
            return name;
        }
        LinkedList<String> list = new LinkedList<String>();
        list.addFirst(name);
        while (doc != null) {
            list.addFirst(doc.getName());
            doc = doc.getParent();
        }
        return StringUtils.join(list, (char)'/');
    }

    public Document getChild(String name) {
        return this.session.getChild(this.id, name);
    }

    public List<Document> getChildren() {
        return this.session.getChildren(this.id);
    }

    public List<String> getChildrenIds() {
        return this.session.getChildrenIds(this.id);
    }

    public boolean hasChild(String name) {
        return this.session.hasChild(this.id, name);
    }

    public boolean hasChildren() {
        return this.session.hasChildren(this.id);
    }

    public Document addChild(String name, String typeName) {
        return this.session.createChild(null, this.id, name, null, typeName);
    }

    public void orderBefore(String src, String dest) {
        Document destDoc;
        Document srcDoc = this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentNotFoundException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentNotFoundException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.id, srcDoc.getUUID(), destDoc == null ? null : destDoc.getUUID());
    }

    public Serializable getPropertyValue(String name) {
        DBSDocumentState docState = this.getStateOrTarget(name);
        return docState.get(name);
    }

    public void setPropertyValue(String name, Serializable value) {
        DBSDocumentState docState = this.getStateOrTarget(name);
        docState.put(name, value);
    }

    protected State getChild(State state, String name, Type type) {
        return (State)state.get((Object)name);
    }

    protected State getChildForWrite(State state, String name, Type type) throws PropertyException {
        State child = this.getChild(state, name, type);
        if (child == null) {
            child = new State();
            state.put(name, (Serializable)child);
        }
        return child;
    }

    protected List<State> getChildAsList(State state, String name) {
        ArrayList list = (ArrayList)state.get((Object)name);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    protected void updateList(State state, String name, Field field, String xpath, List<Object> values) {
        ArrayList<State> childStates = new ArrayList<State>(values.size());
        int i = 0;
        for (Object v : values) {
            State childState = new State();
            this.setValueComplex((StateAccessor)childState, field, xpath + CHANGE_TOKEN_PROXY_SEP + i, v);
            childStates.add(childState);
            ++i;
        }
        state.put(name, (Serializable)childStates);
    }

    protected List<State> updateList(State state, String name, Property property) throws PropertyException {
        int i;
        int oldSize;
        Collection properties = property.getChildren();
        int newSize = properties.size();
        ArrayList<State> childStates = (ArrayList<State>)state.get((Object)name);
        if (newSize == 0) {
            if (childStates != null) {
                state.put(name, null);
            }
            return null;
        }
        if (childStates == null) {
            childStates = new ArrayList<State>(newSize);
            state.put(name, (Serializable)childStates);
        }
        if ((oldSize = childStates.size()) > newSize) {
            for (i = oldSize - 1; i >= newSize; --i) {
                childStates.remove(i);
            }
        }
        if (oldSize < newSize) {
            for (i = oldSize; i < newSize; ++i) {
                childStates.add(new State());
            }
        }
        return childStates;
    }

    public Object getValue(String xpath) throws PropertyException {
        DBSDocumentState docState = this.getStateOrTarget(xpath);
        return this.getValueObject((StateAccessor)docState.getState(), xpath);
    }

    public void setValue(String xpath, Object value) throws PropertyException {
        DBSDocumentState docState = this.getStateOrTarget(xpath);
        docState.markDirty();
        this.setValueObject((StateAccessor)docState.getState(), xpath, value);
    }

    public void visitBlobs(Consumer<Document.BlobAccessor> blobVisitor) throws PropertyException {
        if (this.isProxy()) {
            this.getTargetDocument().visitBlobs(blobVisitor);
        }
        this.visitBlobs((StateAccessor)this.docState.getState(), blobVisitor, this.docState::markDirty);
    }

    public String replaceBlobDigest(String key, String newKey, String newDigest) {
        MutableObject oldDigestHolder = new MutableObject();
        this.visitBlobs(accessor -> this.replaceBlobDigest((Document.BlobAccessor)accessor, key, newKey, newDigest, (MutableObject<String>)oldDigestHolder));
        return (String)oldDigestHolder.getValue();
    }

    protected void replaceBlobDigest(Document.BlobAccessor accessor, String key, String newKey, String newDigest, MutableObject<String> oldDigestHolder) {
        Blob blob = accessor.getBlob();
        if (!(blob instanceof SimpleManagedBlob)) {
            return;
        }
        SimpleManagedBlob managedBlob = (SimpleManagedBlob)blob;
        if (!managedBlob.getKey().equals(key)) {
            return;
        }
        oldDigestHolder.setValue((Object)String.valueOf(blob.getDigest()));
        accessor.setBlob((Blob)managedBlob.withKeyAndDigest(newKey, newDigest));
    }

    protected DocumentBlobManager getDocumentBlobManager() {
        return (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
    }

    public void makeRecord() {
        DBSDocumentState docState = this.getStateOrTarget();
        docState.put(KEY_IS_RECORD, Boolean.TRUE);
        DBSDocument doc = this.session.getDocument(docState);
        this.getDocumentBlobManager().notifyMakeRecord((Document)doc);
    }

    public boolean isRecord() {
        DBSDocumentState docState = this.getStateOrTarget();
        return Boolean.TRUE.equals(docState.get(KEY_IS_RECORD));
    }

    public void setRetainUntil(Calendar retainUntil) throws PropertyException {
        DBSDocumentState docState = this.getStateOrTarget();
        Calendar current = (Calendar)docState.get(KEY_RETAIN_UNTIL);
        if (!this.allowNewRetention(current, retainUntil)) {
            throw new PropertyException("Cannot reduce retention time from: " + (Serializable)(current == null ? "null" : current.toInstant()) + " to: " + (Serializable)(retainUntil == null ? "null" : retainUntil.toInstant()));
        }
        docState.put(KEY_RETAIN_UNTIL, retainUntil);
        DBSDocument doc = this.session.getDocument(docState);
        this.getDocumentBlobManager().notifySetRetainUntil((Document)doc, retainUntil);
    }

    public Calendar getRetainUntil() {
        DBSDocumentState docState = this.getStateOrTarget();
        return (Calendar)docState.get(KEY_RETAIN_UNTIL);
    }

    public void setLegalHold(boolean hold) {
        DBSDocumentState docState = this.getStateOrTarget();
        docState.put(KEY_HAS_LEGAL_HOLD, hold ? Boolean.TRUE : null);
        DBSDocument doc = this.session.getDocument(docState);
        this.getDocumentBlobManager().notifySetLegalHold((Document)doc, hold);
    }

    public boolean hasLegalHold() {
        DBSDocumentState docState = this.getStateOrTarget();
        return Boolean.TRUE.equals(docState.get(KEY_HAS_LEGAL_HOLD));
    }

    public boolean isRetentionActive() {
        DBSDocumentState docState = this.getStateOrTarget();
        return Boolean.TRUE.equals(docState.get(KEY_IS_RETENTION_ACTIVE));
    }

    public void setRetentionActive(boolean retentionActive) {
        DBSDocumentState docState = this.getStateOrTarget();
        docState.put(KEY_IS_RETENTION_ACTIVE, retentionActive ? Boolean.TRUE : null);
    }

    public Document checkIn(String label, String checkinComment) {
        if (this.isRecord()) {
            throw new PropertyException("Record cannot be checked in: " + this.getUUID());
        }
        if (this.isProxy()) {
            return this.getTargetDocument().checkIn(label, checkinComment);
        }
        if (this.isVersion()) {
            throw new VersionNotModifiableException();
        }
        Document version = this.session.checkIn(this.id, label, checkinComment);
        this.getDocumentBlobManager().freezeVersion(version);
        return version;
    }

    public void checkOut() {
        if (this.isProxy()) {
            this.getTargetDocument().checkOut();
        } else {
            if (this.isVersion()) {
                throw new VersionNotModifiableException();
            }
            this.session.checkOut(this.id);
        }
    }

    public List<String> getVersionsIds() {
        return this.session.getVersionsIds(this.getVersionSeriesId());
    }

    public List<Document> getVersions() {
        List<String> ids = this.session.getVersionsIds(this.getVersionSeriesId());
        ArrayList<Document> versions = new ArrayList<Document>();
        for (String id : ids) {
            versions.add((Document)this.session.getDocument(id));
        }
        return versions;
    }

    public Document getLastVersion() {
        return this.session.getLastVersion(this.getVersionSeriesId());
    }

    public Document getSourceDocument() {
        if (this.isProxy()) {
            return this.getTargetDocument();
        }
        if (this.isVersion()) {
            return this.getWorkingCopy();
        }
        return this;
    }

    public void restore(Document version) {
        if (!version.isVersion()) {
            throw new NuxeoException("Cannot restore a non-version: " + version);
        }
        this.session.restoreVersion((Document)this, version);
    }

    public Document getVersion(String label) {
        DBSDocumentState state = this.session.getVersionByLabel(this.getVersionSeriesId(), label);
        return this.session.getDocument(state);
    }

    public Document getBaseVersion() {
        if (this.isProxy()) {
            return this.getTargetDocument().getBaseVersion();
        }
        if (this.isVersion()) {
            return null;
        }
        if (this.isCheckedOut()) {
            return null;
        }
        String id = (String)((Object)this.docState.get(KEY_BASE_VERSION_ID));
        if (id == null) {
            return null;
        }
        return this.session.getDocument(id);
    }

    public boolean isCheckedOut() {
        if (this.isProxy()) {
            return this.getTargetDocument().isCheckedOut();
        }
        if (this.isVersion()) {
            return false;
        }
        return !Boolean.TRUE.equals(this.docState.get(KEY_IS_CHECKED_IN));
    }

    public String getVersionSeriesId() {
        if (this.isProxy()) {
            return (String)((Object)this.docState.get(KEY_PROXY_VERSION_SERIES_ID));
        }
        if (this.isVersion()) {
            return (String)((Object)this.docState.get(KEY_VERSION_SERIES_ID));
        }
        return this.getUUID();
    }

    public Calendar getVersionCreationDate() {
        DBSDocumentState docState = this.getStateOrTarget();
        return (Calendar)docState.get(KEY_VERSION_CREATED);
    }

    public String getVersionLabel() {
        DBSDocumentState docState = this.getStateOrTarget();
        return (String)((Object)docState.get(KEY_VERSION_LABEL));
    }

    public String getCheckinComment() {
        DBSDocumentState docState = this.getStateOrTarget();
        return (String)((Object)docState.get(KEY_VERSION_DESCRIPTION));
    }

    public boolean isLatestVersion() {
        return this.isEqualOnVersion(Boolean.TRUE, KEY_IS_LATEST_VERSION);
    }

    public boolean isMajorVersion() {
        return this.isEqualOnVersion(ZERO, KEY_MINOR_VERSION);
    }

    public boolean isLatestMajorVersion() {
        return this.isEqualOnVersion(Boolean.TRUE, KEY_IS_LATEST_MAJOR_VERSION);
    }

    protected boolean isEqualOnVersion(Object ob, String key) {
        if (this.isProxy()) {
            if (this.getTargetDocument().isVersion()) {
                return ob.equals(this.docState.get(key));
            }
            return false;
        }
        if (this.isVersion()) {
            return ob.equals(this.docState.get(key));
        }
        return false;
    }

    public boolean isVersionSeriesCheckedOut() {
        if (this.isProxy() || this.isVersion()) {
            Document workingCopy = this.getWorkingCopy();
            return workingCopy != null && workingCopy.isCheckedOut();
        }
        return this.isCheckedOut();
    }

    public Document getWorkingCopy() {
        if (this.isProxy() || this.isVersion()) {
            String versionSeriesId = this.getVersionSeriesId();
            return versionSeriesId == null ? null : this.session.getDocument(versionSeriesId);
        }
        return this;
    }

    public boolean isFolder() {
        return this.type == null || this.type.isFolder();
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void remove() {
        this.remove(null);
    }

    public void remove(NuxeoPrincipal principal) {
        this.session.remove(this.id, principal);
    }

    public void removeSingleton() {
        this.session.removeDocument(this.id);
    }

    public String getLifeCycleState() {
        DBSDocumentState docState = this.getStateOrTarget();
        return (String)((Object)docState.get(KEY_LIFECYCLE_STATE));
    }

    public void setCurrentLifeCycleState(String lifeCycleState) throws LifeCycleException {
        DBSDocumentState docState = this.getStateOrTarget();
        docState.put(KEY_LIFECYCLE_STATE, (Serializable)((Object)lifeCycleState));
        this.getDocumentBlobManager().notifyChanges((Document)this, Collections.singleton(KEY_LIFECYCLE_STATE));
    }

    public String getLifeCyclePolicy() {
        DBSDocumentState docState = this.getStateOrTarget();
        return (String)((Object)docState.get(KEY_LIFECYCLE_POLICY));
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        DBSDocumentState docState = this.getStateOrTarget();
        docState.put(KEY_LIFECYCLE_POLICY, (Serializable)((Object)policy));
        this.getDocumentBlobManager().notifyChanges((Document)this, Collections.singleton(KEY_LIFECYCLE_POLICY));
    }

    public void followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = (LifeCycleService)Framework.getService(LifeCycleService.class);
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        LifeCycleService service = (LifeCycleService)Framework.getService(LifeCycleService.class);
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getLifeCycleState());
    }

    public void setSystemProp(String name, Serializable value) {
        String propertyName;
        if (name.startsWith(SYSPROP_FULLTEXT_SIMPLE)) {
            propertyName = name.replace(SYSPROP_FULLTEXT_SIMPLE, KEY_FULLTEXT_SIMPLE);
            if (this.session.fulltextStoredInBlob) {
                return;
            }
        } else if (name.startsWith(SYSPROP_FULLTEXT_BINARY)) {
            propertyName = name.replace(SYSPROP_FULLTEXT_BINARY, KEY_FULLTEXT_BINARY);
            if (this.session.fulltextStoredInBlob) {
                if (!(value instanceof String)) {
                    throw new PropertyException("Property " + name + " must be a string");
                }
                this.setPropertyBlobData(propertyName, (String)((Object)value));
                return;
            }
        } else {
            propertyName = systemPropNameMap.get(name);
        }
        if (propertyName == null) {
            throw new PropertyNotFoundException(name, "Unknown system property");
        }
        this.setPropertyValue(propertyName, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new PropertyNotFoundException(name, "Unknown system property: ");
        }
        Serializable value = this.getPropertyValue(propertyName);
        if (value == null) {
            if (type == Boolean.class) {
                value = Boolean.FALSE;
            } else if (type == Long.class) {
                value = Long.valueOf(0L);
            }
        }
        return (T)value;
    }

    public String getChangeToken() {
        if (this.session.changeTokenEnabled) {
            Long sysChangeToken = this.docState.getSysChangeToken();
            Long changeToken = this.docState.getChangeToken();
            String userVisibleChangeToken = DBSDocument.buildUserVisibleChangeToken((Long)sysChangeToken, (Long)changeToken);
            if (this.isProxy()) {
                String targetUserVisibleChangeToken = this.getTargetDocument().getChangeToken();
                return DBSDocument.getProxyUserVisibleChangeToken(userVisibleChangeToken, targetUserVisibleChangeToken);
            }
            return userVisibleChangeToken;
        }
        DBSDocumentState docState = this.getStateOrTarget();
        Calendar modified = (Calendar)docState.get(KEY_DC_MODIFIED);
        return this.getLegacyChangeToken(modified);
    }

    protected static String getProxyUserVisibleChangeToken(String proxyToken, String targetToken) {
        if (proxyToken == null && targetToken == null) {
            return null;
        }
        if (proxyToken == null) {
            proxyToken = "";
        } else if (targetToken == null) {
            targetToken = "";
        }
        return proxyToken + CHANGE_TOKEN_PROXY_SEP + targetToken;
    }

    public boolean validateUserVisibleChangeToken(String userVisibleChangeToken) {
        if (userVisibleChangeToken == null) {
            return true;
        }
        if (this.session.changeTokenEnabled) {
            if (this.isProxy()) {
                return DBSDocument.validateProxyChangeToken(userVisibleChangeToken, this.docState, this.getTargetDocument().docState);
            }
            return this.docState.validateUserVisibleChangeToken(userVisibleChangeToken);
        }
        DBSDocumentState docState = this.getStateOrTarget();
        Calendar modified = (Calendar)docState.get(KEY_DC_MODIFIED);
        return this.validateLegacyChangeToken(modified, userVisibleChangeToken);
    }

    protected static boolean validateProxyChangeToken(String userVisibleChangeToken, DBSDocumentState proxyState, DBSDocumentState targetState) {
        String targetToken;
        String[] parts = userVisibleChangeToken.split(CHANGE_TOKEN_PROXY_SEP, 2);
        if (parts.length != 2) {
            return false;
        }
        String proxyToken = parts[0];
        if (proxyToken.isEmpty()) {
            proxyToken = null;
        }
        if ((targetToken = parts[1]).isEmpty()) {
            targetToken = null;
        }
        if (proxyToken == null && targetToken == null) {
            return true;
        }
        return proxyState.validateUserVisibleChangeToken(proxyToken) && targetState.validateUserVisibleChangeToken(targetToken);
    }

    public void markUserChange() {
        if (this.isProxy()) {
            this.session.markUserChange(this.getTargetDocumentId());
        }
        this.session.markUserChange(this.id);
    }

    protected DBSDocumentState getStateOrTarget(Type type) throws PropertyException {
        return this.getStateOrTargetForSchema(type.getName());
    }

    protected DBSDocumentState getStateOrTarget(String xpath) {
        return this.getStateOrTargetForSchema(this.getSchema(xpath));
    }

    protected DBSDocumentState getStateOrTargetForSchema(String schema) {
        if (this.isProxy() && !this.isSchemaForProxy(schema)) {
            return this.getTargetDocument().docState;
        }
        return this.docState;
    }

    protected DBSDocumentState getStateOrTarget() {
        if (this.isProxy()) {
            return this.getTargetDocument().docState;
        }
        return this.docState;
    }

    protected boolean isSchemaForProxy(String schema) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        return schemaManager.isProxySchema(schema, this.getType().getName());
    }

    protected String getSchema(String xpath) {
        switch (xpath) {
            case "ecm:majorVersion": 
            case "ecm:minorVersion": 
            case "major_version": 
            case "minor_version": {
                return "uid";
            }
            case "ecm:fulltextJobId": 
            case "ecm:isTrashed": 
            case "ecm:lifeCyclePolicy": 
            case "ecm:lifeCycleState": 
            case "ecm:blobKeys": {
                return "__ecm__";
            }
        }
        if (xpath.startsWith(KEY_FULLTEXT_SIMPLE) || xpath.startsWith(KEY_FULLTEXT_BINARY)) {
            return "__ecm__";
        }
        String[] segments = xpath.split(CHANGE_TOKEN_PROXY_SEP);
        String segment = segments[0];
        Field field = this.type.getField(segment);
        if (field == null) {
            String facet;
            CompositeType facetType;
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            String[] stringArray = this.getFacets();
            int n = stringArray.length;
            for (int i = 0; i < n && (field = (facetType = schemaManager.getFacet(facet = stringArray[i])).getField(segment)) == null; ++i) {
            }
        }
        if (field == null && this.getProxySchemas() != null) {
            Schema schema;
            Iterator<Schema> iterator = this.getProxySchemas().iterator();
            while (iterator.hasNext() && (field = (schema = iterator.next()).getField(segment)) == null) {
            }
        }
        if (field == null) {
            throw new PropertyNotFoundException(xpath);
        }
        return field.getDeclaringType().getName();
    }

    public void readDocumentPart(DocumentPart dp) throws PropertyException {
        DBSDocumentState docState = this.getStateOrTarget(dp.getType());
        this.readComplexProperty((StateAccessor)docState.getState(), (ComplexProperty)dp);
    }

    protected String internalName(String name) {
        switch (name) {
            case "major_version": {
                return KEY_MAJOR_VERSION;
            }
            case "minor_version": {
                return KEY_MINOR_VERSION;
            }
        }
        return name;
    }

    public boolean writeDocumentPart(DocumentPart dp, Document.WriteContext writeContext, boolean create) throws PropertyException {
        DBSDocumentState docState = this.getStateOrTarget(dp.getType());
        docState.markDirty();
        boolean changed = this.writeDocumentPart((StateAccessor)docState.getState(), dp, writeContext, create);
        DBSDocument.clearDirtyFlags((Property)dp);
        return changed;
    }

    public Set<String> getAllFacets() {
        HashSet<String> facets = new HashSet<String>(this.getType().getFacets());
        facets.addAll(Arrays.asList(this.getFacets()));
        return facets;
    }

    public String[] getFacets() {
        DBSDocumentState docState = this.getStateOrTarget();
        Object[] mixins = (Object[])docState.get(KEY_MIXIN_TYPES);
        if (mixins == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] res = new String[mixins.length];
        System.arraycopy(mixins, 0, res, 0, mixins.length);
        return res;
    }

    public boolean hasFacet(String facet) {
        return this.getAllFacets().contains(facet);
    }

    public boolean addFacet(String facet) {
        if (this.getType().getFacets().contains(facet)) {
            return false;
        }
        DBSDocumentState docState = this.getStateOrTarget();
        Object[] mixins = (Object[])docState.get(KEY_MIXIN_TYPES);
        if (mixins == null) {
            mixins = new Object[]{facet};
        } else {
            List<Object> list = Arrays.asList(mixins);
            if (list.contains(facet)) {
                return false;
            }
            list = new ArrayList<Object>(list);
            list.add(facet);
            mixins = list.toArray(new Object[list.size()]);
        }
        docState.put(KEY_MIXIN_TYPES, (Serializable)mixins);
        return true;
    }

    public boolean removeFacet(String facet) {
        DBSDocumentState docState = this.getStateOrTarget();
        Object[] mixins = (Object[])docState.get(KEY_MIXIN_TYPES);
        if (mixins == null) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(mixins));
        if (!list.remove(facet)) {
            return false;
        }
        mixins = list.toArray(new Object[list.size()]);
        if (mixins.length == 0) {
            mixins = null;
        }
        docState.put(KEY_MIXIN_TYPES, (Serializable)mixins);
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        CompositeType ft = schemaManager.getFacet(facet);
        Set<String> otherSchemas = DBSDocument.getSchemas(this.getType(), list);
        for (Schema schema : ft.getSchemas()) {
            if (otherSchemas.contains(schema.getName())) continue;
            for (Field field : schema.getFields()) {
                String name = field.getName().getPrefixedName();
                if (!docState.containsKey(name)) continue;
                docState.put(name, null);
            }
        }
        return true;
    }

    protected static Set<String> getSchemas(DocumentType type, List<Object> facets) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        HashSet<String> schemas = new HashSet<String>(Arrays.asList(type.getSchemaNames()));
        for (Object facet : facets) {
            CompositeType ft = schemaManager.getFacet((String)facet);
            if (ft == null) continue;
            schemas.addAll(Arrays.asList(ft.getSchemaNames()));
        }
        return schemas;
    }

    public DBSDocument getTargetDocument() {
        String targetId = this.getTargetDocumentId();
        return targetId == null ? null : this.session.getDocument(targetId);
    }

    protected String getTargetDocumentId() {
        return this.isProxy() ? (String)((Object)this.docState.get(KEY_PROXY_TARGET_ID)) : null;
    }

    public void setTargetDocument(Document target) {
        if (this.isProxy()) {
            if (this.isReadOnly()) {
                throw new ReadOnlyPropertyException("Cannot write proxy: " + this);
            }
            if (!target.getVersionSeriesId().equals(this.getVersionSeriesId())) {
                throw new ReadOnlyPropertyException("Cannot set proxy target to different version series");
            }
        } else {
            throw new NuxeoException("Cannot set proxy target on non-proxy");
        }
        this.session.setProxyTarget((Document)this, target);
    }

    protected Lock getDocumentLock() {
        String owner = (String)((Object)this.docState.get(KEY_LOCK_OWNER));
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)this.docState.get(KEY_LOCK_CREATED);
        return new Lock(owner, created);
    }

    protected Lock setDocumentLock(Lock lock) {
        String owner = (String)((Object)this.docState.get(KEY_LOCK_OWNER));
        if (owner != null) {
            Calendar created = (Calendar)this.docState.get(KEY_LOCK_CREATED);
            return new Lock(owner, created);
        }
        this.docState.put(KEY_LOCK_OWNER, (Serializable)((Object)lock.getOwner()));
        this.docState.put(KEY_LOCK_CREATED, lock.getCreated());
        return null;
    }

    protected Lock removeDocumentLock(String owner) {
        String oldOwner = (String)((Object)this.docState.get(KEY_LOCK_OWNER));
        if (oldOwner == null) {
            return null;
        }
        Calendar oldCreated = (Calendar)this.docState.get(KEY_LOCK_CREATED);
        if (!LockManager.canLockBeRemoved((String)oldOwner, (String)owner)) {
            return new Lock(oldOwner, oldCreated, true);
        }
        this.docState.put(KEY_LOCK_OWNER, null);
        this.docState.put(KEY_LOCK_CREATED, null);
        return new Lock(oldOwner, oldCreated);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.getName() + "," + this.getUUID() + ")";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == ((Object)((Object)this)).getClass()) {
            return this.equals((DBSDocument)((Object)other));
        }
        return false;
    }

    private boolean equals(DBSDocument other) {
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static {
        systemPropNameMap.put(SYSPROP_FULLTEXT_JOBID, KEY_FULLTEXT_JOBID);
        systemPropNameMap.put(SYSPROP_IS_TRASHED, KEY_IS_TRASHED);
    }
}

