/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.rendering.RenderingContext;
import org.nuxeo.ecm.platform.rendering.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.RenderingException;
import org.nuxeo.ecm.platform.rendering.RenderingResult;
import org.nuxeo.ecm.platform.rendering.RenderingService;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class RenderingServiceImpl
extends DefaultComponent
implements RenderingService {
    private static final Logger log = LogManager.getLogger(RenderingServiceImpl.class);
    public static final String EP_RENDER_ENGINES = "engines";
    private Map<String, RenderingEngine> engines;

    public void start(ComponentContext context) {
        this.engines = new ConcurrentHashMap<String, RenderingEngine>();
        this.getRegistryContributions(EP_RENDER_ENGINES).forEach(desc -> {
            try {
                RenderingEngine engine = desc.newInstance();
                this.engines.put(desc.getFormat(), engine);
            }
            catch (ReflectiveOperationException e) {
                String message = String.format("Cannot register rendering engine for %s", desc.getFormat());
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, message);
                log.error(message, (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.engines = null;
    }

    @Override
    public RenderingEngine getEngine(String name) {
        return this.engines.get(name);
    }

    @Override
    public Collection<RenderingResult> process(RenderingContext renderingCtx) throws RenderingException {
        ArrayList<RenderingResult> ret = new ArrayList<RenderingResult>();
        for (RenderingEngine engine : this.engines.values()) {
            if (!renderingCtx.accept(engine)) continue;
            RenderingResult result = engine.process(renderingCtx);
            if (result != null) {
                ret.add(result);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = engine::getFormatName;
            log.debug("rendering ignored by the engine {}", supplierArray);
        }
        return ret;
    }

    @Override
    public void registerEngine(RenderingEngine engine) {
        RenderingEngine existing = this.engines.put(engine.getFormatName(), engine);
        if (existing != null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = engine::getFormatName;
            log.debug("Replaced existing RenderingEngine {}", supplierArray);
        } else if (log.isDebugEnabled()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = engine::getFormatName;
            log.debug("Registered RenderingEngine {}", supplierArray);
        }
    }

    @Override
    public void unregisterEngine(String name) {
        this.engines.remove(name);
    }
}

