/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.template;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendering.template.DocumentFieldAccessor;

public class DocumentModelAdapter
implements TemplateHashModelEx,
AdapterTemplateModel {
    protected final DocumentModel doc;
    protected final ObjectWrapper wrapper;
    private TemplateCollectionModel keys;
    private int size = -1;

    public DocumentModelAdapter(DocumentModel doc, ObjectWrapper wrapper) {
        this.doc = doc;
        this.wrapper = wrapper;
    }

    public DocumentModelAdapter(DocumentModel doc) {
        this(doc, ObjectWrapper.DEFAULT_WRAPPER);
    }

    public Object getAdaptedObject(Class hint) {
        return this.doc;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        DocumentFieldAccessor accessor = DocumentFieldAccessor.get(key);
        if (accessor != null) {
            return this.wrapper.wrap(accessor.getValue(this.doc));
        }
        Map properties = this.doc.getProperties(key);
        if (properties != null) {
            return this.wrapper.wrap(DocumentModelAdapter.unPrefixedMap(properties));
        }
        return this.wrapper.wrap(null);
    }

    private static Map<String, Object> unPrefixedMap(Map<String, Object> props) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : props.entrySet()) {
            String key = e.getKey();
            int pos = key.indexOf(58);
            if (pos > -1) {
                key = key.substring(pos + 1);
            }
            res.put(key, e.getValue());
        }
        return res;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        if (this.keys == null) {
            ArrayList<String> keysCol = new ArrayList<String>();
            keysCol.addAll(DocumentFieldAccessor.getFieldNames());
            String[] schemas = this.doc.getSchemas();
            keysCol.addAll(Arrays.asList(schemas));
            this.size = keysCol.size();
            this.keys = (TemplateCollectionModel)this.wrapper.wrap(keysCol);
        }
        return this.keys;
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (DocumentFieldAccessor accessor : DocumentFieldAccessor.getAcessors()) {
            values.add(accessor.getValue(this.doc));
        }
        for (String schema : this.doc.getSchemas()) {
            Map properties = this.doc.getProperties(schema);
            if (properties == null) continue;
            values.add(properties);
        }
        return (TemplateCollectionModel)this.wrapper.wrap(values);
    }

    public int size() throws TemplateModelException {
        if (this.size == -1) {
            this.size = DocumentFieldAccessor.getAcessorsCount() + this.doc.getSchemas().length;
        }
        return this.size;
    }
}

