/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import java.util.Arrays;
import java.util.HashMap;
import org.bson.Document;
import org.nuxeo.directory.mongodb.MongoDBDirectoryDescriptor;
import org.nuxeo.directory.mongodb.MongoDBReference;
import org.nuxeo.directory.mongodb.MongoDBReferenceDescriptor;
import org.nuxeo.directory.mongodb.MongoDBSerializationHelper;
import org.nuxeo.directory.mongodb.MongoDBSession;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBDirectory
extends AbstractDirectory {
    public static final String DIRECTORY_CONNECTION_PREFIX = "directory/";
    public static final String ACE_INFO_COLLECTION = "aceinfo";
    public static final String ACE_INFO_ID = "aceinfo:id";
    protected MongoDatabase database;
    protected MongoCollection<Document> collection;
    protected MongoCollection<Document> countersCollection;

    public MongoDBDirectory(MongoDBDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor, MongoDBReference.class);
        this.fallbackOnDefaultCache();
    }

    public MongoDBDirectoryDescriptor getDescriptor() {
        return (MongoDBDirectoryDescriptor)this.descriptor;
    }

    protected void addReferences() {
        super.addReferences();
        MongoDBReferenceDescriptor[] descs = this.getDescriptor().getMongoDBReferences();
        if (descs != null) {
            Arrays.stream(descs).map(MongoDBReference::new).forEach(arg_0 -> ((MongoDBDirectory)this).addReference(arg_0));
        }
    }

    public MongoDBSession getSession() {
        MongoDBSession session = new MongoDBSession(this);
        this.addSession((Session)session);
        return session;
    }

    public boolean isMultiTenant() {
        return this.schemaFieldMap.containsKey("tenantId");
    }

    public void initialize() {
        super.initialize();
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        this.database = mongoService.getDatabase(DIRECTORY_CONNECTION_PREFIX + this.getName());
        this.collection = this.database.getCollection(this.getName());
        String countersCollectionName = this.getName() + ".counters";
        this.countersCollection = this.database.getCollection(countersCollectionName);
        if (this.descriptor.isAutoincrementIdField() && !this.hasCollection(countersCollectionName)) {
            HashMap<String, Object> seq = new HashMap<String, Object>();
            seq.put("_id", this.getName());
            seq.put("seq", 0L);
            this.getCountersCollection().insertOne((Object)MongoDBSerializationHelper.fieldMapToBson(seq));
        }
        String policy = this.descriptor.getCreateTablePolicy();
        boolean dropCollection = false;
        boolean collectionExists = true;
        switch (policy) {
            case "always": {
                dropCollection = true;
                collectionExists = false;
                break;
            }
            case "on_missing_columns": {
                if (this.hasCollection(this.getName())) break;
                collectionExists = false;
                break;
            }
        }
        if (dropCollection) {
            this.collection.drop();
        }
        if (this.isMultiTenant()) {
            this.collection.createIndex(Indexes.hashed((String)"tenantId"));
        }
        if (this.isACEInfo()) {
            this.collection.createIndex(Indexes.ascending((String[])new String[]{ACE_INFO_ID}));
        }
        this.loadDataOnInit(collectionExists);
    }

    public void initializeReferences() {
        try (MongoDBSession session = this.getSession();){
            for (Reference reference : this.getReferences()) {
                if (!(reference instanceof MongoDBReference)) continue;
                ((MongoDBReference)reference).initialize(session);
            }
        }
    }

    protected boolean hasCollection(String collection) {
        return MongoDBConnectionHelper.hasCollection((MongoDatabase)this.database, (String)collection);
    }

    protected MongoCollection<Document> getCollection() {
        return this.collection;
    }

    protected MongoCollection<Document> getCountersCollection() {
        return this.countersCollection;
    }

    protected boolean isACEInfo() {
        return ACE_INFO_COLLECTION.equals(this.collection.getNamespace().getCollectionName());
    }
}

