/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.bulk;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.bulk.BulkService;

@Operation(id="Bulk.WaitForAction", category="Services", label="Wait for Bulk computation", since="10.2", description="Wait until Bulk computation is done. This operation is meant to be used for tests. Its usage in production is not recommended.", addToStudio=false)
public class BulkWaitForAction {
    public static final String ID = "Bulk.WaitForAction";
    @Context
    protected BulkService bulkService;
    @Context
    protected CoreSession repo;
    @Param(name="commandId")
    protected String commandId;
    @Param(name="timeoutSecond", required=false)
    protected long timeout = 60L;

    @OperationMethod
    public Boolean run() {
        try {
            if (!this.bulkService.await(this.commandId, Duration.ofSeconds(this.timeout))) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException | TimeoutException e) {
            if (ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                Thread.currentThread().interrupt();
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

